/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.contentpackagebuilder;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.wcm.tooling.commons.contentpackagebuilder.AcHandling;
import io.wcm.tooling.commons.contentpackagebuilder.PackageFilter;
import io.wcm.tooling.commons.contentpackagebuilder.XmlNamespaces;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO8601;

final class PackageMetadata {
    private static final Set<String> VALID_PACKAGE_TYPES = ImmutableSet.of((Object)"application", (Object)"content", (Object)"container", (Object)"mixed");
    private String group;
    private String name;
    private String description;
    private String createdBy = "admin";
    private Date created = new Date();
    private String version = "1.0";
    private AcHandling acHandling;
    private String packageType;
    private boolean requiresRoot;
    private boolean requiresRestart;
    private boolean allowIndexDefinitions;
    private final List<PackageFilter> filters = new ArrayList<PackageFilter>();
    private final Map<String, String> xmlNamespaces = new HashMap<String, String>();
    private final Map<String, Object> additionalProperties = new HashMap<String, Object>();
    private byte[] thumbnailImage;

    PackageMetadata() {
        this.xmlNamespaces.putAll(XmlNamespaces.DEFAULT_NAMESPACES);
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setAcHandling(AcHandling acHandling) {
        this.acHandling = acHandling;
    }

    public void setPackageType(String packageType) {
        this.packageType = packageType;
    }

    public void setRequiresRoot(boolean requiresRoot) {
        this.requiresRoot = requiresRoot;
    }

    public void setRequiresRestart(boolean requiresRestart) {
        this.requiresRestart = requiresRestart;
    }

    public void setAllowIndexDefinitions(boolean allowIndexDefinitions) {
        this.allowIndexDefinitions = allowIndexDefinitions;
    }

    public void addFilter(PackageFilter filter) {
        this.filters.add(filter);
    }

    public List<PackageFilter> getFilters() {
        return ImmutableList.copyOf(this.filters);
    }

    public void addXmlNamespace(String prefix, String uri) {
        this.xmlNamespaces.put(prefix, uri);
    }

    public void addProperty(String property, Object value) {
        this.additionalProperties.put(property, value);
    }

    public Map<String, String> getXmlNamespaces() {
        return ImmutableMap.copyOf(this.xmlNamespaces);
    }

    public void setThumbnailImage(byte[] thumbnailImage) {
        this.thumbnailImage = thumbnailImage;
    }

    public byte[] getThumbnailImage() {
        return this.thumbnailImage;
    }

    public void validate() {
        if (StringUtils.isEmpty((CharSequence)this.name) || StringUtils.isEmpty((CharSequence)this.group)) {
            throw new IllegalArgumentException("Package name or group not set.");
        }
        if (this.filters.isEmpty()) {
            throw new IllegalArgumentException("No package filter defined / no package root path set.");
        }
        if (this.created == null) {
            throw new IllegalArgumentException("Package creation date not set.");
        }
        if (this.packageType != null && !VALID_PACKAGE_TYPES.contains(this.packageType)) {
            throw new IllegalArgumentException("Invalid packageType: " + this.packageType);
        }
    }

    public Map<String, Object> getVars() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.created);
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("group", StringUtils.defaultString((String)this.group));
        vars.put("name", StringUtils.defaultString((String)this.name));
        vars.put("description", StringUtils.defaultString((String)this.description));
        vars.put("created", ISO8601.format((Calendar)calendar));
        vars.put("createdBy", StringUtils.defaultString((String)this.createdBy));
        vars.put("version", StringUtils.defaultString((String)this.version));
        vars.put("acHandling", this.acHandling != null ? this.acHandling.getMode() : "");
        vars.put("packageType", StringUtils.defaultString((String)this.packageType));
        vars.put("requiresRoot", this.requiresRoot);
        if (this.requiresRestart) {
            vars.put("requiresRestart", this.requiresRestart);
        }
        vars.put("allowIndexDefinitions", this.allowIndexDefinitions);
        vars.putAll(this.additionalProperties);
        return ImmutableMap.copyOf(vars);
    }
}

