/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.contentpackagebuilder;

import java.io.InputStream;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.vault.util.DocViewProperty;

final class ValueConverter {
    static final String PN_PRIVILEGES = "rep:privileges";

    ValueConverter() {
    }

    public String toString(String propertyName, Object value) {
        Value[] values;
        if (value == null) {
            return "";
        }
        boolean multiple = value.getClass().isArray();
        if (multiple) {
            values = new Value[Array.getLength(value)];
            int lastPropertyType = 0;
            for (int i = 0; i < values.length; ++i) {
                values[i] = this.toValue(propertyName, Array.get(value, i));
                if (lastPropertyType == 0) {
                    lastPropertyType = values[i].getType();
                    continue;
                }
                if (lastPropertyType == values[i].getType()) continue;
                throw new RuntimeException("Mixing different value types within array not allowed: " + PropertyType.nameFromValue((int)lastPropertyType) + ", " + PropertyType.nameFromValue((int)values[i].getType()) + ", propertyName=" + propertyName + ", value=" + value);
            }
        } else {
            values = new Value[]{this.toValue(propertyName, value)};
        }
        MockProperty prop = new MockProperty(propertyName, multiple, values);
        try {
            return DocViewProperty.format((Property)prop);
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Unable to format property value (" + propertyName + "): " + value, ex);
        }
    }

    private Value toValue(String propertyName, Object value) {
        if (value instanceof String) {
            if (StringUtils.equals((CharSequence)propertyName, (CharSequence)PN_PRIVILEGES)) {
                return new MockValue(value.toString(), 7);
            }
            return new MockValue(value.toString(), 1);
        }
        if (value instanceof Boolean) {
            return new MockValue(((Boolean)value).toString(), 6);
        }
        if (value instanceof Integer || value instanceof Long) {
            return new MockValue(Long.toString(((Number)value).longValue()), 3);
        }
        if (value instanceof Float || value instanceof Double) {
            return new MockValue(Double.toString(((Number)value).doubleValue()), 12);
        }
        if (value instanceof BigDecimal) {
            return new MockValue(((BigDecimal)value).toString(), 12);
        }
        if (value instanceof Date) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)value);
            return new MockValue(ISO8601.format((Calendar)calendar), 5);
        }
        if (value instanceof Calendar) {
            return new MockValue(ISO8601.format((Calendar)((Calendar)value)), 5);
        }
        if (value instanceof UUID) {
            return new MockValue(((UUID)value).toString(), 9);
        }
        if (value instanceof URI) {
            return new MockValue(((URI)value).toString(), 11);
        }
        throw new IllegalArgumentException("Type not supported: " + value.getClass().getName());
    }

    private static class MockValue
    implements Value {
        private final String value;
        private final int type;

        MockValue(String value, int type) {
            this.value = value;
            this.type = type;
        }

        public String getString() throws ValueFormatException, IllegalStateException, RepositoryException {
            return this.value;
        }

        public int getType() {
            return this.type;
        }

        public InputStream getStream() {
            throw new UnsupportedOperationException();
        }

        public Binary getBinary() {
            throw new UnsupportedOperationException();
        }

        public long getLong() {
            throw new UnsupportedOperationException();
        }

        public double getDouble() {
            throw new UnsupportedOperationException();
        }

        public BigDecimal getDecimal() {
            throw new UnsupportedOperationException();
        }

        public Calendar getDate() {
            throw new UnsupportedOperationException();
        }

        public boolean getBoolean() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MockProperty
    implements Property,
    PropertyDefinition {
        private final String name;
        private final boolean multiple;
        private final Value[] values;

        MockProperty(String name, boolean multiple, Value[] values) {
            this.name = name;
            this.multiple = multiple;
            this.values = values;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            if (this.values.length > 0) {
                return this.values[0].getType();
            }
            return 0;
        }

        public boolean isMultiple() {
            return this.multiple;
        }

        public Value getValue() throws ValueFormatException {
            if (this.multiple) {
                throw new ValueFormatException("Property is multiple.");
            }
            return this.values[0];
        }

        public Value[] getValues() throws ValueFormatException {
            if (!this.multiple) {
                throw new ValueFormatException("Property is not multiple.");
            }
            return this.values;
        }

        public PropertyDefinition getDefinition() {
            return this;
        }

        public String getPath() {
            throw new UnsupportedOperationException();
        }

        public Item getAncestor(int depth) {
            throw new UnsupportedOperationException();
        }

        public Node getParent() {
            throw new UnsupportedOperationException();
        }

        public int getDepth() {
            throw new UnsupportedOperationException();
        }

        public Session getSession() {
            throw new UnsupportedOperationException();
        }

        public boolean isNode() {
            throw new UnsupportedOperationException();
        }

        public boolean isNew() {
            throw new UnsupportedOperationException();
        }

        public boolean isModified() {
            throw new UnsupportedOperationException();
        }

        public boolean isSame(Item otherItem) {
            throw new UnsupportedOperationException();
        }

        public void accept(ItemVisitor visitor) {
            throw new UnsupportedOperationException();
        }

        public void save() {
            throw new UnsupportedOperationException();
        }

        public void refresh(boolean keepChanges) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void setValue(Value value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Value[] value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String[] value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(InputStream value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Binary value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(long value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(double value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Calendar value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Node value) {
            throw new UnsupportedOperationException();
        }

        public String getString() {
            throw new UnsupportedOperationException();
        }

        public InputStream getStream() {
            throw new UnsupportedOperationException();
        }

        public Binary getBinary() {
            throw new UnsupportedOperationException();
        }

        public long getLong() {
            throw new UnsupportedOperationException();
        }

        public double getDouble() {
            throw new UnsupportedOperationException();
        }

        public BigDecimal getDecimal() {
            throw new UnsupportedOperationException();
        }

        public Calendar getDate() {
            throw new UnsupportedOperationException();
        }

        public boolean getBoolean() {
            throw new UnsupportedOperationException();
        }

        public Node getNode() {
            throw new UnsupportedOperationException();
        }

        public Property getProperty() {
            throw new UnsupportedOperationException();
        }

        public long getLength() {
            throw new UnsupportedOperationException();
        }

        public long[] getLengths() {
            throw new UnsupportedOperationException();
        }

        public NodeType getDeclaringNodeType() {
            throw new UnsupportedOperationException();
        }

        public boolean isAutoCreated() {
            throw new UnsupportedOperationException();
        }

        public boolean isMandatory() {
            throw new UnsupportedOperationException();
        }

        public int getOnParentVersion() {
            throw new UnsupportedOperationException();
        }

        public boolean isProtected() {
            throw new UnsupportedOperationException();
        }

        public int getRequiredType() {
            throw new UnsupportedOperationException();
        }

        public String[] getValueConstraints() {
            throw new UnsupportedOperationException();
        }

        public Value[] getDefaultValues() {
            throw new UnsupportedOperationException();
        }

        public String[] getAvailableQueryOperators() {
            throw new UnsupportedOperationException();
        }

        public boolean isFullTextSearchable() {
            throw new UnsupportedOperationException();
        }

        public boolean isQueryOrderable() {
            throw new UnsupportedOperationException();
        }
    }
}

