/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.contentpackagebuilder;

import io.wcm.tooling.commons.contentpackagebuilder.NameUtil;
import io.wcm.tooling.commons.contentpackagebuilder.PackageFilter;
import io.wcm.tooling.commons.contentpackagebuilder.PackageFilterRule;
import io.wcm.tooling.commons.contentpackagebuilder.PropertiesEntityResolver;
import io.wcm.tooling.commons.contentpackagebuilder.ValueConverter;
import io.wcm.tooling.commons.contentpackagebuilder.element.ContentElement;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

final class XmlContentBuilder {
    private final DocumentBuilder documentBuilder;
    private final Map<String, String> xmlNamespaces;
    private final ValueConverter valueConverter = new ValueConverter();
    static final String PN_PRIMARY_TYPE = "jcr:primaryType";
    static final String NT_PAGE = "cq:Page";
    static final String NT_PAGE_CONTENT = "cq:PageContent";
    static final String NT_UNSTRUCTURED = "nt:unstructured";
    static final String NT_FILE = "nt:file";
    static final String NT_RESOURCE = "nt:resource";

    XmlContentBuilder(Map<String, String> xmlNamespaces) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.documentBuilder.setEntityResolver(new PropertiesEntityResolver());
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Failed to set up XML document builder: " + ex.getMessage(), ex);
        }
        this.xmlNamespaces = xmlNamespaces;
    }

    public Document buildPage(ContentElement content) {
        Document doc = this.documentBuilder.newDocument();
        Element jcrRoot = this.createJcrRoot(doc, NT_PAGE);
        Element jcrContent = this.createJcrContent(doc, jcrRoot, NT_PAGE_CONTENT);
        this.exportPayload(doc, jcrContent, content);
        return doc;
    }

    public Document buildPage(Map<String, Object> content) {
        Document doc = this.documentBuilder.newDocument();
        Element jcrRoot = this.createJcrRoot(doc, NT_PAGE);
        Element jcrContent = this.createJcrContent(doc, jcrRoot, NT_PAGE_CONTENT);
        this.exportPayload(doc, jcrContent, content);
        return doc;
    }

    public Document buildContent(ContentElement content) {
        Document doc = this.documentBuilder.newDocument();
        String primaryType = StringUtils.defaultString((String)((String)content.getProperties().get(PN_PRIMARY_TYPE)), (String)NT_UNSTRUCTURED);
        Element jcrRoot = this.createJcrRoot(doc, primaryType);
        this.exportPayload(doc, jcrRoot, content);
        return doc;
    }

    public Document buildContent(Map<String, Object> content) {
        Document doc = this.documentBuilder.newDocument();
        String primaryType = StringUtils.defaultString((String)((String)content.get(PN_PRIMARY_TYPE)), (String)NT_UNSTRUCTURED);
        Element jcrRoot = this.createJcrRoot(doc, primaryType);
        this.exportPayload(doc, jcrRoot, content);
        return doc;
    }

    public Document buildNtFile(String mimeType, String encoding) {
        Document doc = this.documentBuilder.newDocument();
        Element jcrRoot = this.createJcrRoot(doc, NT_FILE);
        Element jcrContent = this.createJcrContent(doc, jcrRoot, NT_RESOURCE);
        if (StringUtils.isNotEmpty((CharSequence)mimeType)) {
            this.setAttributeNamespaceAware(jcrContent, "jcr:mimeType", mimeType);
        }
        if (StringUtils.isNotEmpty((CharSequence)encoding)) {
            this.setAttributeNamespaceAware(jcrContent, "jcr:encoding", encoding);
        }
        return doc;
    }

    public Document buildFilter(List<PackageFilter> filters) {
        Document doc = this.documentBuilder.newDocument();
        Element workspaceFilterElement = doc.createElement("workspaceFilter");
        workspaceFilterElement.setAttribute("version", "1.0");
        doc.appendChild(workspaceFilterElement);
        for (PackageFilter filter : filters) {
            Element filterElement = doc.createElement("filter");
            filterElement.setAttribute("root", filter.getRootPath());
            workspaceFilterElement.appendChild(filterElement);
            for (PackageFilterRule rule : filter.getRules()) {
                Element ruleElement = doc.createElement(rule.isInclude() ? "include" : "exclude");
                ruleElement.setAttribute("pattern", rule.getPattern());
                filterElement.appendChild(ruleElement);
            }
        }
        return doc;
    }

    private Element createJcrRoot(Document doc, String primaryType) {
        Element jcrRoot = doc.createElementNS("http://www.jcp.org/jcr/1.0", "jcr:root");
        for (Map.Entry<String, String> namespace : this.xmlNamespaces.entrySet()) {
            jcrRoot.setAttribute("xmlns:" + namespace.getKey(), namespace.getValue());
        }
        this.setAttributeNamespaceAware(jcrRoot, PN_PRIMARY_TYPE, primaryType);
        doc.appendChild(jcrRoot);
        return jcrRoot;
    }

    private Element createJcrContent(Document doc, Element jcrRoot, String primaryType) {
        Element jcrContent = doc.createElementNS("http://www.jcp.org/jcr/1.0", "jcr:content");
        this.setAttributeNamespaceAware(jcrContent, PN_PRIMARY_TYPE, primaryType);
        jcrRoot.appendChild(jcrContent);
        return jcrContent;
    }

    private void exportPayload(Document doc, Element element, ContentElement content) {
        for (Map.Entry<String, Object> entry : content.getProperties().entrySet()) {
            Object value = entry.getValue();
            if (value == null || this.hasAttributeNamespaceAware(element, entry.getKey())) continue;
            String stringValue = this.valueConverter.toString(entry.getKey(), value);
            this.setAttributeNamespaceAware(element, entry.getKey(), stringValue);
        }
        for (Map.Entry<String, Object> entry : content.getChildren().entrySet()) {
            ContentElement child = (ContentElement)entry.getValue();
            Element subElement = doc.createElement(this.validateAndEncodeName(entry.getKey()));
            if (!this.hasAttributeNamespaceAware(subElement, PN_PRIMARY_TYPE) && !child.getProperties().containsKey(PN_PRIMARY_TYPE)) {
                this.setAttributeNamespaceAware(subElement, PN_PRIMARY_TYPE, NT_UNSTRUCTURED);
            }
            element.appendChild(subElement);
            this.exportPayload(doc, subElement, child);
        }
    }

    private void exportPayload(Document doc, Element element, Map<String, Object> content) {
        for (Map.Entry<String, Object> entry : content.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Map) {
                Map childMap = (Map)value;
                Element subElement = doc.createElement(this.validateAndEncodeName(entry.getKey()));
                if (!this.hasAttributeNamespaceAware(subElement, PN_PRIMARY_TYPE) && !childMap.containsKey(PN_PRIMARY_TYPE)) {
                    this.setAttributeNamespaceAware(subElement, PN_PRIMARY_TYPE, NT_UNSTRUCTURED);
                }
                element.appendChild(subElement);
                this.exportPayload(doc, subElement, childMap);
                continue;
            }
            if (this.hasAttributeNamespaceAware(element, entry.getKey())) continue;
            String stringValue = this.valueConverter.toString(entry.getKey(), value);
            this.setAttributeNamespaceAware(element, entry.getKey(), stringValue);
        }
    }

    private void setAttributeNamespaceAware(Element element, String key, String value) {
        String namespace = this.getNamespace(key);
        if (namespace == null) {
            element.setAttribute(this.validateAndEncodeName(key), value);
        } else {
            element.setAttributeNS(namespace, this.validateAndEncodeName(key), value);
        }
    }

    private boolean hasAttributeNamespaceAware(Element element, String key) {
        String namespace = this.getNamespace(key);
        if (namespace == null) {
            return element.hasAttribute(key);
        }
        return element.hasAttributeNS(namespace, key);
    }

    private String getNamespace(String key) {
        if (!StringUtils.contains((CharSequence)key, (CharSequence)":")) {
            return null;
        }
        String nsPrefix = StringUtils.substringBefore((String)key, (String)":");
        return this.xmlNamespaces.get(nsPrefix);
    }

    private String validateAndEncodeName(String name) {
        if (!NameUtil.isValidName(name)) {
            throw new IllegalArgumentException("Illegal name (not following JCR standards): " + name);
        }
        return ISO9075.encode((String)name);
    }
}

