/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr;

import io.wcm.tooling.commons.packmgr.PackageManagerException;
import io.wcm.tooling.commons.packmgr.PackageManagerHttpActionException;
import io.wcm.tooling.commons.packmgr.PackageManagerProperties;
import io.wcm.tooling.commons.packmgr.Proxy;
import io.wcm.tooling.commons.packmgr.httpaction.BundleStatus;
import io.wcm.tooling.commons.packmgr.httpaction.BundleStatusCall;
import io.wcm.tooling.commons.packmgr.httpaction.HttpCall;
import io.wcm.tooling.commons.packmgr.httpaction.PackageManagerHtmlCall;
import io.wcm.tooling.commons.packmgr.httpaction.PackageManagerHtmlMessageCall;
import io.wcm.tooling.commons.packmgr.httpaction.PackageManagerInstallStatus;
import io.wcm.tooling.commons.packmgr.httpaction.PackageManagerInstallStatusCall;
import io.wcm.tooling.commons.packmgr.httpaction.PackageManagerJsonCall;
import io.wcm.tooling.commons.packmgr.httpaction.PackageManagerStatusCall;
import io.wcm.tooling.commons.packmgr.httpaction.PackageManagerXmlCall;
import io.wcm.tooling.commons.packmgr.util.HttpClientUtil;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.jdom2.Document;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageManagerHelper {
    public static final String CRX_PACKAGE_EXISTS_ERROR_MESSAGE_PREFIX = "Package already exists: ";
    private static final String HTTP_CONTEXT_ATTRIBUTE_PREEMPTIVE_AUTHENTICATION_CREDS = PackageManagerHelper.class.getName() + "_PreemptiveAuthenticationCreds";
    private static final String HTTP_CONTEXT_ATTRIBUTE_OAUTH2_ACCESS_TOKEN = PackageManagerHelper.class.getName() + "_oauth2AccessToken";
    private final PackageManagerProperties props;
    private static final Logger log = LoggerFactory.getLogger(PackageManagerHelper.class);

    public PackageManagerHelper(PackageManagerProperties props) {
        this.props = props;
    }

    @NotNull
    public CloseableHttpClient getHttpClient() {
        Proxy proxy;
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setKeepAliveStrategy(new ConnectionKeepAliveStrategy(){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return 1L;
            }
        }).addInterceptorFirst(new HttpRequestInterceptor(){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                String oauth2AccessToken;
                Credentials credentials = (Credentials)context.getAttribute(HTTP_CONTEXT_ATTRIBUTE_PREEMPTIVE_AUTHENTICATION_CREDS);
                if (credentials != null) {
                    AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
                    authState.update((AuthScheme)new BasicScheme(), credentials);
                }
                if ((oauth2AccessToken = (String)context.getAttribute(HTTP_CONTEXT_ATTRIBUTE_OAUTH2_ACCESS_TOKEN)) != null) {
                    request.setHeader("Authorization", "Bearer " + oauth2AccessToken);
                }
            }
        });
        if (this.props.isRelaxedSSLCheck()) {
            try {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)new NoopHostnameVerifier());
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException ex) {
                throw new PackageManagerException("Could not set relaxedSSLCheck", ex);
            }
        }
        if ((proxy = this.getProxyForUrl(this.props.getPackageManagerUrl())) != null) {
            httpClientBuilder.setProxy(new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol()));
        }
        return httpClientBuilder.build();
    }

    @NotNull
    public HttpClientContext getPackageManagerHttpClientContext() {
        return this.getHttpClientContext(this.props.getPackageManagerUrl(), this.props.getUserId(), this.props.getPassword(), this.props.getOAuth2AccessToken());
    }

    @Nullable
    public HttpClientContext getConsoleHttpClientContext() {
        String bundleStatusUrl = this.props.getBundleStatusUrl();
        if (bundleStatusUrl == null) {
            return null;
        }
        return this.getHttpClientContext(bundleStatusUrl, this.props.getConsoleUserId(), this.props.getConsolePassword(), this.props.getConsoleOAuth2AccessToken());
    }

    @NotNull
    private HttpClientContext getHttpClientContext(String url, String userId, String password, String oauth2AccessToken) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException ex) {
            throw new PackageManagerException("Invalid url: " + url, ex);
        }
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        HttpClientContext context = new HttpClientContext();
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        if (StringUtils.isNotBlank((CharSequence)oauth2AccessToken)) {
            context.setAttribute(HTTP_CONTEXT_ATTRIBUTE_OAUTH2_ACCESS_TOKEN, (Object)oauth2AccessToken);
        } else {
            AuthScope authScope = new AuthScope(uri.getHost(), uri.getPort());
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userId, password);
            credsProvider.setCredentials(authScope, (Credentials)credentials);
            context.setAttribute(HTTP_CONTEXT_ATTRIBUTE_PREEMPTIVE_AUTHENTICATION_CREDS, (Object)credentials);
        }
        context.setRequestConfig(HttpClientUtil.buildRequestConfig(this.props));
        Proxy proxy = this.getProxyForUrl(url);
        if (proxy != null && proxy.useAuthentication()) {
            AuthScope proxyAuthScope = new AuthScope(proxy.getHost(), proxy.getPort());
            UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword());
            credsProvider.setCredentials(proxyAuthScope, (Credentials)proxyCredentials);
        }
        return context;
    }

    private Proxy getProxyForUrl(String requestUrl) {
        List<Proxy> proxies = this.props.getProxies();
        if (proxies == null || proxies.isEmpty()) {
            return null;
        }
        URI uri = URI.create(requestUrl);
        for (Proxy proxy : proxies) {
            if (proxy.isNonProxyHost(uri.getHost())) continue;
            return proxy;
        }
        return null;
    }

    private <T> T executeHttpCallWithRetry(HttpCall<T> call, int runCount) {
        try {
            return call.execute();
        }
        catch (PackageManagerHttpActionException ex) {
            if (runCount < this.props.getRetryCount()) {
                log.warn("ERROR: {}", (Object)ex.getMessage());
                log.debug("HTTP call failed.", (Throwable)ex);
                log.warn("---------------");
                StringBuilder msg = new StringBuilder();
                msg.append("HTTP call failed, try again (" + (runCount + 1) + "/" + this.props.getRetryCount() + ")");
                if (this.props.getRetryDelaySec() > 0) {
                    msg.append(" after " + this.props.getRetryDelaySec() + " second(s)");
                }
                msg.append("...");
                log.warn(msg.toString());
                if (this.props.getRetryDelaySec() > 0) {
                    try {
                        Thread.sleep((long)this.props.getRetryDelaySec() * 1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                return this.executeHttpCallWithRetry(call, runCount + 1);
            }
            throw ex;
        }
    }

    public JSONObject executePackageManagerMethodJson(CloseableHttpClient httpClient, HttpClientContext context, HttpRequestBase method) {
        PackageManagerJsonCall call = new PackageManagerJsonCall(httpClient, context, method);
        return this.executeHttpCallWithRetry(call, 0);
    }

    public Document executePackageManagerMethodXml(CloseableHttpClient httpClient, HttpClientContext context, HttpRequestBase method) {
        PackageManagerXmlCall call = new PackageManagerXmlCall(httpClient, context, method);
        return this.executeHttpCallWithRetry(call, 0);
    }

    public String executePackageManagerMethodHtml(CloseableHttpClient httpClient, HttpClientContext context, HttpRequestBase method) {
        PackageManagerHtmlCall call = new PackageManagerHtmlCall(httpClient, context, method);
        return this.executeHttpCallWithRetry(call, 0);
    }

    public void executePackageManagerMethodHtmlOutputResponse(CloseableHttpClient httpClient, HttpClientContext context, HttpRequestBase method) {
        PackageManagerHtmlMessageCall call = new PackageManagerHtmlMessageCall(httpClient, context, method, this.props);
        this.executeHttpCallWithRetry(call, 0);
    }

    public void executePackageManagerMethodStatus(CloseableHttpClient httpClient, HttpClientContext context, HttpRequestBase method) {
        PackageManagerStatusCall call = new PackageManagerStatusCall(httpClient, context, method);
        this.executeHttpCallWithRetry(call, 0);
    }

    public void waitForBundlesActivation(CloseableHttpClient httpClient, HttpClientContext context) {
        if (StringUtils.isBlank((CharSequence)this.props.getBundleStatusUrl())) {
            log.debug("Skipping check for bundle activation state because no bundleStatusURL is defined.");
            return;
        }
        int WAIT_INTERVAL_SEC = 3;
        long CHECK_RETRY_COUNT = this.props.getBundleStatusWaitLimitSec() / 3;
        log.info("Check bundle activation status...");
        int i = 1;
        while ((long)i <= CHECK_RETRY_COUNT) {
            BundleStatusCall call = new BundleStatusCall(httpClient, context, this.props.getBundleStatusUrl(), this.props.getBundleStatusWhitelistBundleNames());
            BundleStatus bundleStatus = this.executeHttpCallWithRetry(call, 0);
            boolean instanceReady = true;
            if (!bundleStatus.isAllBundlesRunning()) {
                log.info("Bundles starting/stopping: {} - wait {} sec (max. {} sec) ...", new Object[]{bundleStatus.getStatusLineCompact(), 3, this.props.getBundleStatusWaitLimitSec()});
                this.sleep(3);
                instanceReady = false;
            }
            if (instanceReady) {
                for (Pattern blacklistBundleNamePattern : this.props.getBundleStatusBlacklistBundleNames()) {
                    String bundleSymbolicName = bundleStatus.getMatchingBundle(blacklistBundleNamePattern);
                    if (bundleSymbolicName == null) continue;
                    log.info("Bundle '{}' is still deployed - wait {} sec (max. {} sec) ...", new Object[]{bundleSymbolicName, 3, this.props.getBundleStatusWaitLimitSec()});
                    this.sleep(3);
                    instanceReady = false;
                    break;
                }
            }
            if (instanceReady) break;
            ++i;
        }
    }

    public void waitForPackageManagerInstallStatusFinished(CloseableHttpClient httpClient, HttpClientContext context) {
        if (StringUtils.isBlank((CharSequence)this.props.getPackageManagerInstallStatusURL())) {
            log.debug("Skipping check for package manager install state because no packageManagerInstallStatusURL is defined.");
            return;
        }
        int WAIT_INTERVAL_SEC = 3;
        long CHECK_RETRY_COUNT = this.props.getPackageManagerInstallStatusWaitLimitSec() / 3;
        log.info("Check package manager installation status...");
        int i = 1;
        while ((long)i <= CHECK_RETRY_COUNT) {
            PackageManagerInstallStatusCall call = new PackageManagerInstallStatusCall(httpClient, context, this.props.getPackageManagerInstallStatusURL());
            PackageManagerInstallStatus packageManagerStatus = this.executeHttpCallWithRetry(call, 0);
            boolean instanceReady = true;
            if (!packageManagerStatus.isFinished()) {
                log.info("Packager manager not ready: {} packages left for installation - wait {} sec (max. {} sec) ...", new Object[]{packageManagerStatus.getItemCount(), 3, this.props.getPackageManagerInstallStatusWaitLimitSec()});
                this.sleep(3);
                instanceReady = false;
            }
            if (instanceReady) break;
            ++i;
        }
    }

    private void sleep(int sec) {
        try {
            Thread.sleep((long)sec * 1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

