/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.StatusLine;
import org.json.JSONException;

public final class PackageManagerHttpActionException
extends RuntimeException {
    private static final long serialVersionUID = 1L;

    public PackageManagerHttpActionException(String message, Throwable cause) {
        super(message, cause);
    }

    public PackageManagerHttpActionException(String message) {
        super(message);
    }

    public static PackageManagerHttpActionException forIOException(String url, IOException ex) {
        String message = "HTTP call to " + url + " failed: " + StringUtils.defaultString((String)ex.getMessage(), (String)ex.getClass().getSimpleName());
        if (ex instanceof SocketTimeoutException) {
            message = message + " (consider to increase the socket timeout using -Dvault.httpSocketTimeoutSec)";
        }
        return new PackageManagerHttpActionException(message, ex);
    }

    public static PackageManagerHttpActionException forJSONException(String url, String responseString, JSONException ex) {
        String message = "HTTP call to " + url + " failed: JSON parse failure - " + ex.getMessage() + "\n" + StringUtils.abbreviate((String)responseString, (int)200);
        return new PackageManagerHttpActionException(message, (Throwable)ex);
    }

    public static PackageManagerHttpActionException forHttpError(String url, StatusLine statusLine, String responseString) {
        String message = "HTTP call to " + url + " failed with status " + statusLine.getStatusCode() + " " + statusLine.getReasonPhrase() + (responseString != null ? "\n" + responseString : "");
        return new PackageManagerHttpActionException(message);
    }
}

