/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr;

import io.wcm.tooling.commons.packmgr.Proxy;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class PackageManagerProperties {
    private String packageManagerUrl;
    private String userId;
    private String password;
    private String oauth2AccessToken;
    private String consoleUserId;
    private String consolePassword;
    private String consoleOauth2AccessToken;
    private int retryCount = 24;
    private int retryDelaySec = 5;
    private String bundleStatusUrl;
    private int bundleStatusWaitLimitSec = 360;
    private List<Pattern> bundleStatusBlacklistBundleNames = Collections.emptyList();
    private List<Pattern> bundleStatusWhitelistBundleNames = Collections.emptyList();
    private String packageManagerInstallStatusURL;
    private int packageManagerInstallStatusWaitLimitSec = 360;
    private boolean relaxedSSLCheck;
    private int httpConnectTimeoutSec = 10;
    private int httpSocketTimeoutSec = 60;
    private List<Proxy> proxies;
    private String packageManagerOutputLogLevel = "INFO";

    public String getPackageManagerUrl() {
        return this.packageManagerUrl;
    }

    public void setPackageManagerUrl(String packageManagerUrl) {
        this.packageManagerUrl = packageManagerUrl;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getOAuth2AccessToken() {
        return this.oauth2AccessToken;
    }

    public void setOAuth2AccessToken(String value) {
        this.oauth2AccessToken = value;
    }

    public String getConsoleUserId() {
        return StringUtils.defaultString((String)this.consoleUserId, (String)this.userId);
    }

    public void setConsoleUserId(String consoleUserId) {
        this.consoleUserId = consoleUserId;
    }

    public String getConsolePassword() {
        return StringUtils.defaultString((String)this.consolePassword, (String)this.password);
    }

    public void setConsolePassword(String consolePassword) {
        this.consolePassword = consolePassword;
    }

    public String getConsoleOAuth2AccessToken() {
        return StringUtils.defaultString((String)this.consoleOauth2AccessToken, (String)this.oauth2AccessToken);
    }

    public void setConsoleOAuth2AccessToken(String value) {
        this.consoleOauth2AccessToken = value;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public int getRetryDelaySec() {
        return this.retryDelaySec;
    }

    public void setRetryDelaySec(int retryDelaySec) {
        this.retryDelaySec = retryDelaySec;
    }

    public String getBundleStatusUrl() {
        return this.bundleStatusUrl;
    }

    public void setBundleStatusUrl(String bundleStatusUrl) {
        this.bundleStatusUrl = bundleStatusUrl;
    }

    public int getBundleStatusWaitLimitSec() {
        return this.bundleStatusWaitLimitSec;
    }

    public void setBundleStatusWaitLimitSec(int bundleStatusWaitLimitSec) {
        this.bundleStatusWaitLimitSec = bundleStatusWaitLimitSec;
    }

    public List<Pattern> getBundleStatusBlacklistBundleNames() {
        return this.bundleStatusBlacklistBundleNames;
    }

    public void setBundleStatusBlacklistBundleNames(List<String> bundleStatusBlacklistBundleNames) {
        this.bundleStatusBlacklistBundleNames = bundleStatusBlacklistBundleNames.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    public List<Pattern> getBundleStatusWhitelistBundleNames() {
        return this.bundleStatusWhitelistBundleNames;
    }

    public void setBundleStatusWhitelistBundleNames(List<String> bundleStatusWhitelistBundleNames) {
        this.bundleStatusWhitelistBundleNames = bundleStatusWhitelistBundleNames.stream().map(Pattern::compile).collect(Collectors.toList());
    }

    public String getPackageManagerInstallStatusURL() {
        return this.packageManagerInstallStatusURL;
    }

    public void setPackageManagerInstallStatusURL(String packageManagerInstallStatusURL) {
        this.packageManagerInstallStatusURL = packageManagerInstallStatusURL;
    }

    public int getPackageManagerInstallStatusWaitLimitSec() {
        return this.packageManagerInstallStatusWaitLimitSec;
    }

    public void setPackageManagerInstallStatusWaitLimitSec(int packageManagerInstallStatusWaitLimitSec) {
        this.packageManagerInstallStatusWaitLimitSec = packageManagerInstallStatusWaitLimitSec;
    }

    public boolean isRelaxedSSLCheck() {
        return this.relaxedSSLCheck;
    }

    public void setRelaxedSSLCheck(boolean relaxedSSLCheck) {
        this.relaxedSSLCheck = relaxedSSLCheck;
    }

    public int getHttpConnectTimeoutSec() {
        return this.httpConnectTimeoutSec;
    }

    public void setHttpConnectTimeoutSec(int httpConnectTimeoutSec) {
        this.httpConnectTimeoutSec = httpConnectTimeoutSec;
    }

    public int getHttpSocketTimeoutSec() {
        return this.httpSocketTimeoutSec;
    }

    public void setHttpSocketTimeoutSec(int httpSocketTimeoutSec) {
        this.httpSocketTimeoutSec = httpSocketTimeoutSec;
    }

    public List<Proxy> getProxies() {
        return this.proxies;
    }

    public void setProxies(List<Proxy> proxies) {
        this.proxies = proxies;
    }

    public String getPackageManagerOutputLogLevel() {
        return this.packageManagerOutputLogLevel;
    }

    public void setPackageManagerOutputLogLevel(String packageManagerOutputLogLevel) {
        this.packageManagerOutputLogLevel = packageManagerOutputLogLevel;
    }
}

