/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr;

import java.util.StringTokenizer;

public final class Proxy {
    private final String id;
    private final String protocol;
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String nonProxyHosts;

    public Proxy(String id, String protocol, String host, int port, String username, String password, String nonProxyHosts) {
        this.host = host;
        this.id = id;
        this.protocol = protocol;
        this.port = port;
        this.username = username;
        this.password = password;
        this.nonProxyHosts = nonProxyHosts;
    }

    public String getId() {
        return this.id;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getNonProxyHosts() {
        return this.nonProxyHosts;
    }

    boolean useAuthentication() {
        return this.username != null && !this.username.isEmpty();
    }

    boolean isNonProxyHost(String givenHost) {
        if (givenHost != null && this.nonProxyHosts != null && this.nonProxyHosts.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(this.nonProxyHosts, "|");
            while (tokenizer.hasMoreTokens()) {
                String pattern = tokenizer.nextToken();
                if (!givenHost.matches(pattern = pattern.replace(".", "\\.").replace("*", ".*"))) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.id + "{protocol='" + this.protocol + '\'' + ", host='" + this.host + '\'' + ", port=" + this.port + (this.useAuthentication() ? ", with username/passport authentication" : "") + '}';
    }
}

