/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.download;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.tooling.commons.packmgr.PackageManagerException;
import io.wcm.tooling.commons.packmgr.PackageManagerHelper;
import io.wcm.tooling.commons.packmgr.PackageManagerProperties;
import io.wcm.tooling.commons.packmgr.install.VendorInstallerFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageDownloader
implements Closeable {
    private final PackageManagerProperties props;
    private final PackageManagerHelper pkgmgr;
    private final CloseableHttpClient httpClient;
    private static final Logger log = LoggerFactory.getLogger(PackageDownloader.class);

    public PackageDownloader(PackageManagerProperties props) {
        this.props = props;
        this.pkgmgr = new PackageManagerHelper(props);
        this.httpClient = this.pkgmgr.getHttpClient();
    }

    public String uploadPackageDefinition(File file) {
        HttpClientContext httpClientContext = this.pkgmgr.getPackageManagerHttpClientContext();
        if (!file.exists()) {
            throw new PackageManagerException("File not found: " + file.getAbsolutePath());
        }
        log.info("Upload package definition for {} to {} ...", (Object)file.getName(), (Object)this.props.getPackageManagerUrl());
        HttpPost post = new HttpPost(this.props.getPackageManagerUrl() + "/.json?cmd=upload");
        MultipartEntityBuilder entity = MultipartEntityBuilder.create().addBinaryBody("package", file).addTextBody("force", "true");
        post.setEntity(entity.build());
        JSONObject jsonResponse = this.pkgmgr.executePackageManagerMethodJson(this.httpClient, httpClientContext, (HttpRequestBase)post);
        boolean success = jsonResponse.optBoolean("success", false);
        String msg = jsonResponse.optString("msg", null);
        String packagePath = jsonResponse.optString("path", null);
        if (!success && StringUtils.startsWith((CharSequence)msg, (CharSequence)"Package already exists: ") && StringUtils.isEmpty((CharSequence)packagePath)) {
            packagePath = StringUtils.substringAfter((String)msg, (String)"Package already exists: ");
            success = true;
        }
        if (!success) {
            throw new PackageManagerException("Package path detection failed: " + msg);
        }
        return packagePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    public File downloadContentPackage(String packagePath, String ouputFilePath, boolean rebuildPackage) {
        try {
            HttpClientContext httpClientContext = this.pkgmgr.getPackageManagerHttpClientContext();
            if (rebuildPackage) {
                log.info("Rebuilding package {} ...", (Object)packagePath);
                HttpPost buildMethod = new HttpPost(this.props.getPackageManagerUrl() + "/console.html" + packagePath + "?cmd=build");
                this.pkgmgr.executePackageManagerMethodHtmlOutputResponse(this.httpClient, httpClientContext, (HttpRequestBase)buildMethod);
            }
            log.info("Downloading package {} from {} ...", (Object)packagePath, (Object)this.props.getPackageManagerUrl());
            String baseUrl = VendorInstallerFactory.getBaseUrl(this.props.getPackageManagerUrl());
            HttpGet downloadMethod = new HttpGet(baseUrl + packagePath);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)downloadMethod, (HttpContext)httpClientContext);
            try {
                if (response.getStatusLine().getStatusCode() != 200) throw new PackageManagerException("Package download failed:\n" + EntityUtils.toString((HttpEntity)response.getEntity()));
                InputStream responseStream = response.getEntity().getContent();
                File outputFileObject = new File(ouputFilePath);
                if (outputFileObject.exists()) {
                    outputFileObject.delete();
                }
                try (FileOutputStream fos = new FileOutputStream(outputFileObject);){
                    IOUtils.copy((InputStream)responseStream, (OutputStream)fos);
                    fos.flush();
                    responseStream.close();
                }
                log.info("Package downloaded to {}", (Object)outputFileObject.getAbsolutePath());
                File file = outputFileObject;
                return file;
            }
            finally {
                if (response != null) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                    try {
                        response.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException ex) {
            throw new PackageManagerException("Download operation failed.", ex);
        }
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

