/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.httpaction;

import java.util.Set;
import java.util.regex.Pattern;

public final class BundleStatus {
    private final String statusLine;
    private final int total;
    private final int active;
    private final int activeFragment;
    private final int resolved;
    private final int installed;
    private final int ignored;
    private final Set<String> bundleSymbolicNames;

    BundleStatus(String statusLine, int total, int active, int activeFragment, int resolved, int installed, int ignored, Set<String> bundleSymbolicNames) {
        this.statusLine = statusLine;
        this.total = total;
        this.active = active;
        this.activeFragment = activeFragment;
        this.resolved = resolved;
        this.installed = installed;
        this.ignored = ignored;
        this.bundleSymbolicNames = bundleSymbolicNames;
    }

    @Deprecated
    public String getStatusLine() {
        return this.statusLine;
    }

    public String getStatusLineCompact() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.total).append(" total");
        if (this.active > 0) {
            sb.append(", ").append(this.active).append(" active");
        }
        if (this.activeFragment > 0) {
            sb.append(", ").append(this.activeFragment).append(" fragment");
        }
        if (this.resolved > 0) {
            sb.append(", ").append(this.resolved).append(" resolved");
        }
        if (this.installed > 0) {
            sb.append(", ").append(this.installed).append(" installed");
        }
        if (this.ignored > 0) {
            sb.append(", ").append(this.ignored).append(" ignored");
        }
        return sb.toString();
    }

    public int getTotal() {
        return this.total;
    }

    public int getActive() {
        return this.active;
    }

    public int getActiveFragment() {
        return this.activeFragment;
    }

    public int getResolved() {
        return this.resolved;
    }

    public int getInstalled() {
        return this.installed;
    }

    public int getIgnored() {
        return this.ignored;
    }

    public boolean isAllBundlesRunning() {
        return this.getInstalled() + this.getResolved() == 0;
    }

    public boolean containsBundle(String symbolicName) {
        return this.bundleSymbolicNames.contains(symbolicName);
    }

    public String getMatchingBundle(Pattern symbolicNamePattern) {
        for (String bundleSymbolicName : this.bundleSymbolicNames) {
            if (!symbolicNamePattern.matcher(bundleSymbolicName).matches()) continue;
            return bundleSymbolicName;
        }
        return null;
    }
}

