/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.httpaction;

import io.wcm.tooling.commons.packmgr.PackageManagerHttpActionException;
import io.wcm.tooling.commons.packmgr.httpaction.BundleStatus;
import io.wcm.tooling.commons.packmgr.httpaction.BundleStatusParser;
import io.wcm.tooling.commons.packmgr.httpaction.HttpCall;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BundleStatusCall
implements HttpCall<BundleStatus> {
    private final CloseableHttpClient httpClient;
    private final HttpClientContext context;
    private final String bundleStatusURL;
    private final List<Pattern> bundleStatusWhitelistBundleNames;
    private static final Logger log = LoggerFactory.getLogger(BundleStatusCall.class);

    public BundleStatusCall(CloseableHttpClient httpClient, HttpClientContext context, String bundleStatusURL, List<Pattern> bundleStatusWhitelistBundleNames) {
        this.httpClient = httpClient;
        this.context = context;
        this.bundleStatusURL = bundleStatusURL;
        this.bundleStatusWhitelistBundleNames = bundleStatusWhitelistBundleNames;
    }

    @Override
    public BundleStatus execute() {
        BundleStatus bundleStatus;
        block9: {
            log.debug("Call URL: {}", (Object)this.bundleStatusURL);
            HttpGet method = new HttpGet(this.bundleStatusURL);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)method, (HttpContext)this.context);
            try {
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw PackageManagerHttpActionException.forHttpError(this.bundleStatusURL, response.getStatusLine(), responseString);
                }
                bundleStatus = this.toBundleStatus(responseString);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw PackageManagerHttpActionException.forIOException(this.bundleStatusURL, ex);
                }
            }
            response.close();
        }
        return bundleStatus;
    }

    private BundleStatus toBundleStatus(String jsonString) {
        try {
            BundleStatusParser parser = new BundleStatusParser(this.bundleStatusWhitelistBundleNames);
            return parser.parse(jsonString);
        }
        catch (JSONException ex) {
            throw PackageManagerHttpActionException.forJSONException(this.bundleStatusURL, jsonString, ex);
        }
    }
}

