/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.httpaction;

import io.wcm.tooling.commons.packmgr.httpaction.BundleStatus;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

final class BundleStatusParser {
    private final List<Pattern> bundleStatusWhitelistBundleNames;

    BundleStatusParser(List<Pattern> bundleStatusWhitelistBundleNames) {
        this.bundleStatusWhitelistBundleNames = bundleStatusWhitelistBundleNames;
    }

    BundleStatus parse(String jsonString) {
        JSONObject json = new JSONObject(jsonString);
        String statusLine = json.getString("status");
        int total = 0;
        int active = 0;
        int activeFragment = 0;
        int resolved = 0;
        int installed = 0;
        int ignored = 0;
        HashSet<String> bundleSymbolicNames = new HashSet<String>();
        JSONArray data = json.getJSONArray("data");
        for (int i = 0; i < data.length(); ++i) {
            JSONObject item = data.getJSONObject(i);
            String symbolicName = item.optString("symbolicName");
            String state = item.optString("state");
            boolean fragment = item.optBoolean("fragment");
            boolean whitelisted = this.isWhitelisted(symbolicName);
            ++total;
            if (fragment) {
                ++activeFragment;
            } else if (this.isActive(state)) {
                ++active;
            } else if (this.isResolved(state)) {
                if (whitelisted) {
                    ++ignored;
                } else {
                    ++resolved;
                }
            } else if (this.isInstalled(state)) {
                if (whitelisted) {
                    ++ignored;
                } else {
                    ++installed;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)symbolicName) || whitelisted) continue;
            bundleSymbolicNames.add(symbolicName);
        }
        return new BundleStatus(statusLine, total, active, activeFragment, resolved, installed, ignored, bundleSymbolicNames);
    }

    private boolean isActive(String actual) {
        return StringUtils.equalsIgnoreCase((CharSequence)actual, (CharSequence)"Active");
    }

    private boolean isResolved(String actual) {
        return StringUtils.equalsIgnoreCase((CharSequence)actual, (CharSequence)"Resolved");
    }

    private boolean isInstalled(String actual) {
        return StringUtils.equalsIgnoreCase((CharSequence)actual, (CharSequence)"Installed");
    }

    private boolean isWhitelisted(String symbolicName) {
        for (Pattern pattern : this.bundleStatusWhitelistBundleNames) {
            if (!pattern.matcher(symbolicName).matches()) continue;
            return true;
        }
        return false;
    }
}

