/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.httpaction;

import io.wcm.tooling.commons.packmgr.PackageManagerHttpActionException;
import io.wcm.tooling.commons.packmgr.httpaction.HttpCall;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageManagerHtmlCall
implements HttpCall<String> {
    private final CloseableHttpClient httpClient;
    private final HttpClientContext context;
    private final HttpRequestBase method;
    private static final Logger log = LoggerFactory.getLogger(PackageManagerHtmlCall.class);

    public PackageManagerHtmlCall(CloseableHttpClient httpClient, HttpClientContext context, HttpRequestBase method) {
        this.httpClient = httpClient;
        this.context = context;
        this.method = method;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String execute() {
        log.debug("Call URL: {}", (Object)this.method.getURI());
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.method, (HttpContext)this.context);){
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() != 200) throw PackageManagerHttpActionException.forHttpError(this.method.getURI().toString(), response.getStatusLine(), responseString);
            log.debug("CRX Package Manager Response:\n{}", (Object)responseString);
            String string = responseString;
            return string;
        }
        catch (IOException ex) {
            throw PackageManagerHttpActionException.forIOException(this.method.getURI().toString(), ex);
        }
    }
}

