/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.httpaction;

import io.wcm.tooling.commons.packmgr.PackageManagerException;
import io.wcm.tooling.commons.packmgr.PackageManagerHttpActionException;
import io.wcm.tooling.commons.packmgr.PackageManagerProperties;
import io.wcm.tooling.commons.packmgr.httpaction.HttpCall;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageManagerHtmlMessageCall
implements HttpCall<String> {
    private final CloseableHttpClient httpClient;
    private final HttpClientContext context;
    private final HttpRequestBase method;
    private final PackageManagerProperties props;
    private static final String PACKAGE_MANAGER_ERROR_INDICATION = "Error during processing.";
    private static final Logger log = LoggerFactory.getLogger(PackageManagerHtmlMessageCall.class);
    private static final Pattern HTML_STYLE = Pattern.compile("<style[^<>]*>[^<>]*</style>", 40);
    private static final Pattern HTML_JAVASCRIPT = Pattern.compile("<script[^<>]*>[^<>]*</script>", 40);
    private static final Pattern TEXT_LINE_BREAKS = Pattern.compile("[\n\r]");
    private static final Pattern HTML_LINE_BREAKS = Pattern.compile("(<br/?>|</p>|</h\\d>)");
    private static final Pattern HTML_ANYTAG = Pattern.compile("<[^<>]*>");

    public PackageManagerHtmlMessageCall(CloseableHttpClient httpClient, HttpClientContext context, HttpRequestBase method, PackageManagerProperties props) {
        this.httpClient = httpClient;
        this.context = context;
        this.method = method;
        this.props = props;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String execute() {
        log.debug("Call URL: {}", (Object)this.method.getURI());
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.method, (HttpContext)this.context);){
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() != 200) throw PackageManagerHttpActionException.forHttpError(this.method.getURI().toString(), response.getStatusLine(), responseString);
            log.trace("CRX Package Manager Response:\n{}", (Object)responseString);
            responseString = HTML_STYLE.matcher(responseString).replaceAll("");
            responseString = HTML_JAVASCRIPT.matcher(responseString).replaceAll("");
            responseString = TEXT_LINE_BREAKS.matcher(responseString).replaceAll("");
            responseString = HTML_LINE_BREAKS.matcher(responseString).replaceAll("\n");
            responseString = HTML_ANYTAG.matcher(responseString).replaceAll("");
            responseString = StringUtils.replace((String)responseString, (String)"&nbsp;", (String)" ");
            responseString = "\n" + StringUtils.trim((String)responseString);
            if (StringUtils.equalsIgnoreCase((CharSequence)this.props.getPackageManagerOutputLogLevel(), (CharSequence)"debug")) {
                log.debug(responseString);
            } else {
                log.info(responseString);
            }
            if (StringUtils.contains((CharSequence)responseString, (CharSequence)PACKAGE_MANAGER_ERROR_INDICATION)) {
                throw new PackageManagerException("Package installation failed: Error during processing.\n" + this.method.getURI());
            }
            String string = responseString;
            return string;
        }
        catch (IOException ex) {
            throw PackageManagerHttpActionException.forIOException(this.method.getURI().toString(), ex);
        }
    }
}

