/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.httpaction;

import io.wcm.tooling.commons.packmgr.PackageManagerHttpActionException;
import io.wcm.tooling.commons.packmgr.httpaction.HttpCall;
import io.wcm.tooling.commons.packmgr.httpaction.PackageManagerInstallStatus;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageManagerInstallStatusCall
implements HttpCall<PackageManagerInstallStatus> {
    private final CloseableHttpClient httpClient;
    private final HttpClientContext context;
    private final String packageManagerInstallStatusURL;
    private static final Logger log = LoggerFactory.getLogger(PackageManagerInstallStatusCall.class);

    public PackageManagerInstallStatusCall(CloseableHttpClient httpClient, HttpClientContext context, String packageManagerInstallStatusURL) {
        this.httpClient = httpClient;
        this.context = context;
        this.packageManagerInstallStatusURL = packageManagerInstallStatusURL;
    }

    @Override
    public PackageManagerInstallStatus execute() {
        PackageManagerInstallStatus packageManagerInstallStatus;
        block9: {
            log.debug("Call URL: {}", (Object)this.packageManagerInstallStatusURL);
            HttpGet method = new HttpGet(this.packageManagerInstallStatusURL);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)method, (HttpContext)this.context);
            try {
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw PackageManagerHttpActionException.forHttpError(this.packageManagerInstallStatusURL, response.getStatusLine(), responseString);
                }
                packageManagerInstallStatus = this.toPackageManagerInstallStatus(responseString);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw PackageManagerHttpActionException.forIOException(this.packageManagerInstallStatusURL, ex);
                }
            }
            response.close();
        }
        return packageManagerInstallStatus;
    }

    private PackageManagerInstallStatus toPackageManagerInstallStatus(String jsonString) {
        boolean finished = false;
        int itemCount = 0;
        try {
            JSONObject json = new JSONObject(jsonString);
            JSONObject status = json.optJSONObject("status");
            if (status != null) {
                finished = status.optBoolean("finished");
                itemCount = status.optInt("itemCount");
            }
        }
        catch (JSONException ex) {
            throw PackageManagerHttpActionException.forJSONException(this.packageManagerInstallStatusURL, jsonString, ex);
        }
        return new PackageManagerInstallStatus(finished, itemCount);
    }
}

