/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.httpaction;

import io.wcm.tooling.commons.packmgr.PackageManagerHttpActionException;
import io.wcm.tooling.commons.packmgr.httpaction.HttpCall;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageManagerJsonCall
implements HttpCall<JSONObject> {
    private final CloseableHttpClient httpClient;
    private final HttpClientContext context;
    private final HttpRequestBase method;
    private static final Logger log = LoggerFactory.getLogger(PackageManagerJsonCall.class);

    public PackageManagerJsonCall(CloseableHttpClient httpClient, HttpClientContext context, HttpRequestBase method) {
        this.httpClient = httpClient;
        this.context = context;
        this.method = method;
    }

    @Override
    public JSONObject execute() {
        JSONObject jSONObject;
        block14: {
            log.debug("Call URL: {}", (Object)this.method.getURI());
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.method, (HttpContext)this.context);
            try {
                JSONObject jsonResponse = null;
                String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
                if (response.getStatusLine().getStatusCode() == 200) {
                    if (responseString != null) {
                        try {
                            jsonResponse = new JSONObject(responseString);
                        }
                        catch (JSONException ex) {
                            throw PackageManagerHttpActionException.forJSONException(this.method.getURI().toString(), responseString, ex);
                        }
                    }
                    if (jsonResponse == null) {
                        jsonResponse = new JSONObject();
                        jsonResponse.put("success", false);
                        jsonResponse.put("msg", (Object)"Invalid response (null).");
                    }
                } else {
                    throw PackageManagerHttpActionException.forHttpError(this.method.getURI().toString(), response.getStatusLine(), responseString);
                }
                jSONObject = jsonResponse;
                if (response == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw PackageManagerHttpActionException.forIOException(this.method.getURI().toString(), ex);
                }
            }
            response.close();
        }
        return jSONObject;
    }
}

