/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.httpaction;

import io.wcm.tooling.commons.packmgr.PackageManagerHttpActionException;
import io.wcm.tooling.commons.packmgr.httpaction.HttpCall;
import java.io.IOException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageManagerStatusCall
implements HttpCall<Void> {
    private final CloseableHttpClient httpClient;
    private final HttpClientContext context;
    private final HttpRequestBase method;
    private static final Logger log = LoggerFactory.getLogger(PackageManagerStatusCall.class);

    public PackageManagerStatusCall(CloseableHttpClient httpClient, HttpClientContext context, HttpRequestBase method) {
        this.httpClient = httpClient;
        this.context = context;
        this.method = method;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Void execute() {
        log.debug("Call URL: {}", (Object)this.method.getURI());
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.method, (HttpContext)this.context);){
            if (response.getStatusLine().getStatusCode() != 200) throw PackageManagerHttpActionException.forHttpError(this.method.getURI().toString(), response.getStatusLine(), null);
            if (log.isTraceEnabled()) {
                log.trace("CRX Package Manager Response Status : {} {}", (Object)response.getStatusLine().getStatusCode(), (Object)response.getStatusLine().getReasonPhrase());
            }
            Void void_ = null;
            return void_;
        }
        catch (IOException ex) {
            throw PackageManagerHttpActionException.forIOException(this.method.getURI().toString(), ex);
        }
    }
}

