/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.httpaction;

import io.wcm.tooling.commons.packmgr.PackageManagerException;
import io.wcm.tooling.commons.packmgr.PackageManagerHttpActionException;
import io.wcm.tooling.commons.packmgr.httpaction.HttpCall;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageManagerXmlCall
implements HttpCall<Document> {
    private final CloseableHttpClient httpClient;
    private final HttpClientContext context;
    private final HttpRequestBase method;
    private static final SAXBuilder SAX_BUILDER = new SAXBuilder();
    private static final Logger log = LoggerFactory.getLogger(PackageManagerXmlCall.class);

    public PackageManagerXmlCall(CloseableHttpClient httpClient, HttpClientContext context, HttpRequestBase method) {
        this.httpClient = httpClient;
        this.context = context;
        this.method = method;
    }

    @Override
    public Document execute() {
        Document document;
        block18: {
            log.debug("Call URL: {}", (Object)this.method.getURI());
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)this.method, (HttpContext)this.context);
            try {
                Document xmlResponse;
                block17: {
                    xmlResponse = null;
                    if (response.getStatusLine().getStatusCode() == 200) {
                        try (InputStream is = response.getEntity().getContent();){
                            xmlResponse = SAX_BUILDER.build(is);
                            break block17;
                        }
                        catch (JDOMException ex) {
                            throw new PackageManagerException("Error parsing XML response.", ex);
                        }
                    }
                    throw PackageManagerHttpActionException.forHttpError(this.method.getURI().toString(), response.getStatusLine(), null);
                }
                document = xmlResponse;
                if (response == null) break block18;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw PackageManagerHttpActionException.forIOException(this.method.getURI().toString(), ex);
                }
            }
            response.close();
        }
        return document;
    }
}

