/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.install;

import io.wcm.tooling.commons.packmgr.PackageManagerException;
import io.wcm.tooling.commons.packmgr.PackageManagerHelper;
import io.wcm.tooling.commons.packmgr.PackageManagerProperties;
import io.wcm.tooling.commons.packmgr.install.PackageFile;
import io.wcm.tooling.commons.packmgr.install.VendorInstallerFactory;
import io.wcm.tooling.commons.packmgr.install.VendorPackageInstaller;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PackageInstaller {
    private final PackageManagerProperties props;
    private final PackageManagerHelper pkgmgr;
    private boolean replicate;
    private static final Logger log = LoggerFactory.getLogger(PackageInstaller.class);

    public PackageInstaller(PackageManagerProperties props) {
        this.props = props;
        this.pkgmgr = new PackageManagerHelper(props);
    }

    public void setReplicate(boolean replicate) {
        this.replicate = replicate;
    }

    public void installFiles(Collection<PackageFile> packageFiles) {
        try (CloseableHttpClient httpClient = this.pkgmgr.getHttpClient();){
            HttpClientContext packageManagerHttpClientContext = this.pkgmgr.getPackageManagerHttpClientContext();
            HttpClientContext consoleHttpClientContext = this.pkgmgr.getConsoleHttpClientContext();
            for (PackageFile packageFile : packageFiles) {
                this.installFile(packageFile, httpClient, packageManagerHttpClientContext, consoleHttpClientContext);
            }
        }
        catch (IOException ex) {
            throw new PackageManagerException("Install operation failed.", ex);
        }
    }

    public void installFile(PackageFile packageFile) {
        try (CloseableHttpClient httpClient = this.pkgmgr.getHttpClient();){
            HttpClientContext packageManagerHttpClientContext = this.pkgmgr.getPackageManagerHttpClientContext();
            HttpClientContext consoleHttpClientContext = this.pkgmgr.getConsoleHttpClientContext();
            this.installFile(packageFile, httpClient, packageManagerHttpClientContext, consoleHttpClientContext);
        }
        catch (IOException ex) {
            throw new PackageManagerException("Install operation failed.", ex);
        }
    }

    private void installFile(PackageFile packageFile, CloseableHttpClient httpClient, HttpClientContext packageManagerHttpClientContext, HttpClientContext consoleHttpClientContext) throws IOException {
        File file = packageFile.getFile();
        if (!file.exists()) {
            throw new PackageManagerException("File does not exist: " + file.getAbsolutePath());
        }
        this.pkgmgr.waitForBundlesActivation(httpClient, consoleHttpClientContext);
        this.pkgmgr.waitForPackageManagerInstallStatusFinished(httpClient, packageManagerHttpClientContext);
        if (packageFile.isInstall()) {
            log.info("Upload and install {}{} to {}", new Object[]{packageFile.isForce() ? "(force) " : "", file.getName(), this.props.getPackageManagerUrl()});
        } else {
            log.info("Upload {} to {}", (Object)file.getName(), (Object)this.props.getPackageManagerUrl());
        }
        VendorPackageInstaller installer = VendorInstallerFactory.getPackageInstaller(this.props.getPackageManagerUrl());
        if (installer != null) {
            installer.installPackage(packageFile, this.replicate, this.pkgmgr, httpClient, packageManagerHttpClientContext, consoleHttpClientContext, this.props);
        }
    }
}

