/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.install;

import io.wcm.tooling.commons.packmgr.PackageManagerException;
import io.wcm.tooling.commons.packmgr.install.VendorPackageInstaller;
import io.wcm.tooling.commons.packmgr.install.composum.ComposumPackageInstaller;
import io.wcm.tooling.commons.packmgr.install.crx.CrxPackageInstaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VendorInstallerFactory {
    public static final String CRX_URL = "/crx/packmgr/service";
    public static final String COMPOSUM_URL = "/bin/cpm/";
    private static final Logger log = LoggerFactory.getLogger(VendorInstallerFactory.class);

    private VendorInstallerFactory() {
    }

    public static Service identify(String url) {
        Service answer = Service.UNSUPPORTED;
        int index = url.indexOf(COMPOSUM_URL);
        if (index > 0) {
            answer = Service.COMPOSUM;
        } else {
            index = url.indexOf(CRX_URL);
            if (index > 0) {
                answer = Service.CRX;
            }
        }
        return answer;
    }

    public static String getBaseUrl(String url) {
        String answer = url;
        switch (VendorInstallerFactory.identify(url)) {
            case COMPOSUM: {
                answer = url.substring(0, url.indexOf(COMPOSUM_URL));
                break;
            }
            case CRX: {
                answer = url.substring(0, url.indexOf(CRX_URL));
                break;
            }
            default: {
                log.error("Given URL is not supported: {}", (Object)url);
            }
        }
        return answer;
    }

    public static VendorPackageInstaller getPackageInstaller(String url) throws PackageManagerException {
        VendorPackageInstaller answer;
        switch (VendorInstallerFactory.identify(url)) {
            case COMPOSUM: {
                answer = new ComposumPackageInstaller(url);
                break;
            }
            case CRX: {
                answer = new CrxPackageInstaller(url);
                break;
            }
            default: {
                throw new PackageManagerException("Given URL is not supported: " + url);
            }
        }
        return answer;
    }

    public static enum Service {
        CRX,
        COMPOSUM,
        UNSUPPORTED;

    }
}

