/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.install.composum;

import io.wcm.tooling.commons.packmgr.PackageManagerException;
import io.wcm.tooling.commons.packmgr.PackageManagerHelper;
import io.wcm.tooling.commons.packmgr.PackageManagerProperties;
import io.wcm.tooling.commons.packmgr.install.PackageFile;
import io.wcm.tooling.commons.packmgr.install.VendorPackageInstaller;
import io.wcm.tooling.commons.packmgr.util.HttpClientUtil;
import java.io.IOException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComposumPackageInstaller
implements VendorPackageInstaller {
    private final String url;
    private static final Logger log = LoggerFactory.getLogger(ComposumPackageInstaller.class);

    public ComposumPackageInstaller(String url) {
        this.url = url;
    }

    @Override
    public void installPackage(PackageFile packageFile, boolean replicate, PackageManagerHelper pkgmgr, CloseableHttpClient httpClient, HttpClientContext packageManagerHttpClientContext, HttpClientContext consoleHttpClientContext, PackageManagerProperties props) throws IOException, PackageManagerException {
        if (replicate) {
            throw new IllegalArgumentException("Replicating packages not supported for Composum package installer.");
        }
        int index = this.url.indexOf("/bin/cpm/");
        String baseUrl = this.url.substring(0, index) + "/bin/cpm/package.";
        String uploadUrl = baseUrl + "upload.json";
        HttpPost post = new HttpPost(uploadUrl);
        HttpClientUtil.applyRequestConfig((HttpRequestBase)post, packageFile, props);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().addBinaryBody("file", packageFile.getFile());
        if (packageFile.isForce()) {
            entityBuilder.addTextBody("force", "true");
        }
        post.setEntity(entityBuilder.build());
        JSONObject jsonResponse = pkgmgr.executePackageManagerMethodJson(httpClient, packageManagerHttpClientContext, (HttpRequestBase)post);
        String status = jsonResponse.optString("status", "not-found");
        boolean success = "successful".equals(status);
        String path = jsonResponse.optString("path", null);
        if (success) {
            if (packageFile.isInstall()) {
                log.info("Package uploaded, now installing...");
                String installUrl = baseUrl + "install.json" + path;
                post = new HttpPost(installUrl);
                HttpClientUtil.applyRequestConfig((HttpRequestBase)post, packageFile, props);
                JSONObject jsonResponseInstallation = pkgmgr.executePackageManagerMethodJson(httpClient, packageManagerHttpClientContext, (HttpRequestBase)post);
                String installationStatus = jsonResponseInstallation.optString("status", "not-found");
                if (!"done".equals(installationStatus)) {
                    throw new PackageManagerException("Package installation failed: " + status);
                }
                this.delay(packageFile.getDelayAfterInstallSec());
                pkgmgr.waitForBundlesActivation(httpClient, consoleHttpClientContext);
            } else {
                log.info("Package uploaded successfully (without installing).");
            }
        } else {
            throw new PackageManagerException("Package upload failed: " + status);
        }
    }

    private void delay(int seconds) {
        if (seconds > 0) {
            log.info("Wait {} seconds after package install...", (Object)seconds);
            try {
                Thread.sleep((long)seconds * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

