/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.install.crx;

import io.wcm.tooling.commons.packmgr.PackageManagerException;
import io.wcm.tooling.commons.packmgr.PackageManagerHelper;
import io.wcm.tooling.commons.packmgr.PackageManagerProperties;
import io.wcm.tooling.commons.packmgr.install.PackageFile;
import io.wcm.tooling.commons.packmgr.install.VendorInstallerFactory;
import io.wcm.tooling.commons.packmgr.install.VendorPackageInstaller;
import io.wcm.tooling.commons.packmgr.install.crx.PackageInstalledChecker;
import io.wcm.tooling.commons.packmgr.install.crx.PackageInstalledStatus;
import io.wcm.tooling.commons.packmgr.util.ContentPackageProperties;
import io.wcm.tooling.commons.packmgr.util.HttpClientUtil;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrxPackageInstaller
implements VendorPackageInstaller {
    private final String url;
    private static final Logger log = LoggerFactory.getLogger(CrxPackageInstaller.class);

    public CrxPackageInstaller(String url) {
        this.url = url;
    }

    @Override
    public void installPackage(PackageFile packageFile, boolean replicate, PackageManagerHelper pkgmgr, CloseableHttpClient httpClient, HttpClientContext packageManagerHttpClientContext, HttpClientContext consoleHttpClientContext, PackageManagerProperties props) throws IOException, PackageManagerException {
        boolean force = packageFile.isForce();
        if (force) {
            this.ensurePackageManagerAvailability(pkgmgr, httpClient, packageManagerHttpClientContext);
        } else {
            PackageInstalledStatus status = this.getPackageInstalledStatus(packageFile, pkgmgr, httpClient, packageManagerHttpClientContext);
            switch (status) {
                case NOT_FOUND: {
                    log.debug("Package is not found in package list: proceed with install.");
                    break;
                }
                case INSTALLED: {
                    log.info("Package skipped because it was already uploaded.");
                    return;
                }
                case UPLOADED: {
                    log.info("Package was already uploaded but not installed: proceed with install and switch to force mode.");
                    force = true;
                    break;
                }
                case INSTALLED_OTHER_VERSION: {
                    log.info("Package was already uploaded, but another version was installed more recently: proceed with install and switch to force mode.");
                    force = true;
                    break;
                }
                default: {
                    throw new PackageManagerException("Unexpected status: " + (Object)((Object)status));
                }
            }
        }
        HttpPost post = new HttpPost(this.url + "/.json?cmd=upload");
        HttpClientUtil.applyRequestConfig((HttpRequestBase)post, packageFile, props);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create().addBinaryBody("package", packageFile.getFile());
        if (force) {
            entityBuilder.addTextBody("force", "true");
        }
        post.setEntity(entityBuilder.build());
        JSONObject jsonResponse = pkgmgr.executePackageManagerMethodJson(httpClient, packageManagerHttpClientContext, (HttpRequestBase)post);
        boolean success = jsonResponse.optBoolean("success", false);
        String msg = jsonResponse.optString("msg", null);
        String path = jsonResponse.optString("path", null);
        if (success) {
            if (packageFile.isInstall()) {
                log.info("Package uploaded to {}, now installing...", (Object)path);
                try {
                    post = new HttpPost(this.url + "/console.html" + new URIBuilder().setPath(path).build().getRawPath() + "?cmd=install" + (packageFile.isRecursive() ? "&recursive=true" : ""));
                    HttpClientUtil.applyRequestConfig((HttpRequestBase)post, packageFile, props);
                }
                catch (URISyntaxException ex) {
                    throw new PackageManagerException("Invalid path: " + path, ex);
                }
                pkgmgr.executePackageManagerMethodHtmlOutputResponse(httpClient, packageManagerHttpClientContext, (HttpRequestBase)post);
                this.delay(packageFile.getDelayAfterInstallSec());
                pkgmgr.waitForBundlesActivation(httpClient, consoleHttpClientContext);
                pkgmgr.waitForPackageManagerInstallStatusFinished(httpClient, packageManagerHttpClientContext);
            } else {
                log.info("Package uploaded successfully to {} (without installing).", (Object)path);
            }
        } else if (StringUtils.startsWith((CharSequence)msg, (CharSequence)"Package already exists: ") && !force) {
            log.info("Package skipped because it was already uploaded.");
        } else {
            throw new PackageManagerException("Package upload failed: " + msg);
        }
        if (success && replicate) {
            log.info("Replicate package {}...", (Object)path);
            try {
                post = new HttpPost(this.url + "/console.html" + new URIBuilder().setPath(path).build().getRawPath() + "?cmd=replicate");
                HttpClientUtil.applyRequestConfig((HttpRequestBase)post, packageFile, props);
            }
            catch (URISyntaxException ex) {
                throw new PackageManagerException("Invalid path: " + path, ex);
            }
            pkgmgr.executePackageManagerMethodHtmlOutputResponse(httpClient, packageManagerHttpClientContext, (HttpRequestBase)post);
        }
    }

    private void delay(int seconds) {
        if (seconds > 0) {
            log.info("Wait {} seconds after package install...", (Object)seconds);
            try {
                Thread.sleep((long)seconds * 1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void ensurePackageManagerAvailability(PackageManagerHelper pkgmgr, CloseableHttpClient httpClient, HttpClientContext context) {
        HttpGet get = new HttpGet(this.url + ".jsp?cmd=help");
        pkgmgr.executePackageManagerMethodStatus(httpClient, context, (HttpRequestBase)get);
    }

    private PackageInstalledStatus getPackageInstalledStatus(PackageFile packageFile, PackageManagerHelper pkgmgr, CloseableHttpClient httpClient, HttpClientContext context) throws IOException {
        String baseUrl = VendorInstallerFactory.getBaseUrl(this.url);
        String packageListUrl = baseUrl + "/crx/packmgr/list.jsp";
        HttpGet get = new HttpGet(packageListUrl);
        JSONObject result = pkgmgr.executePackageManagerMethodJson(httpClient, context, (HttpRequestBase)get);
        Map<String, Object> props = ContentPackageProperties.get(packageFile.getFile());
        String group = (String)props.get("group");
        String name = (String)props.get("name");
        String version = (String)props.get("version");
        PackageInstalledChecker checker = new PackageInstalledChecker(result);
        return checker.getStatus(group, name, version);
    }
}

