/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.install.crx;

import io.wcm.tooling.commons.packmgr.PackageManagerException;
import io.wcm.tooling.commons.packmgr.install.crx.PackageInstalledStatus;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class PackageInstalledChecker {
    private final JSONArray results;
    static final String PACKMGR_LIST_URL = "/crx/packmgr/list.jsp";
    private static final long NOT_FOUND_DATE = -1L;
    private static final long NOT_UNPACKED_DATE = 0L;

    PackageInstalledChecker(JSONObject result) {
        try {
            this.results = result.getJSONArray("results");
        }
        catch (JSONException ex) {
            throw new PackageManagerException("JSON response from /crx/packmgr/list.jsp does not contain 'results' array.", ex);
        }
    }

    public PackageInstalledStatus getStatus(String group, String name, String version) {
        Map<String, Long> map = this.getVersionUnpackedDates(group, name);
        if (map.isEmpty()) {
            return PackageInstalledStatus.NOT_FOUND;
        }
        long versionUnpackDate = this.getVersionUnpackDate(map, version);
        if (versionUnpackDate == -1L) {
            return PackageInstalledStatus.NOT_FOUND;
        }
        if (versionUnpackDate == 0L) {
            return PackageInstalledStatus.UPLOADED;
        }
        long lastUnpackDate = this.getLastUnpackDate(map);
        if (lastUnpackDate > versionUnpackDate) {
            return PackageInstalledStatus.INSTALLED_OTHER_VERSION;
        }
        return PackageInstalledStatus.INSTALLED;
    }

    private Map<String, Long> getVersionUnpackedDates(String group, String name) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (int i = 0; i < this.results.length(); ++i) {
            JSONObject item = this.results.getJSONObject(i);
            String itemGroup = item.optString("group");
            String itemName = item.optString("name");
            String itemVersion = item.optString("version");
            long itemLastUnpacked = item.optLong("lastUnpacked", 0L);
            if (!StringUtils.equals((CharSequence)group, (CharSequence)itemGroup) || !StringUtils.equals((CharSequence)name, (CharSequence)itemName) || !StringUtils.isNotBlank((CharSequence)itemVersion)) continue;
            map.put(itemVersion, itemLastUnpacked);
        }
        return map;
    }

    private long getVersionUnpackDate(Map<String, Long> map, String version) {
        Long value = map.get(version);
        if (value == null) {
            return -1L;
        }
        return value;
    }

    private long getLastUnpackDate(Map<String, Long> map) {
        long last = 0L;
        for (Long date : map.values()) {
            if (date <= last) continue;
            last = date;
        }
        return last;
    }
}

