/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.unpack;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.wcm.tooling.commons.packmgr.PackageManagerException;
import io.wcm.tooling.commons.packmgr.unpack.ContentUnpackerProperties;
import io.wcm.tooling.commons.packmgr.unpack.OneAttributePerLineXmlProcessor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.jackrabbit.vault.util.DocViewProperty;
import org.apache.jackrabbit.vault.util.PlatformNameFormat;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.LineSeparator;
import org.jdom2.output.XMLOutputter;
import org.jdom2.output.support.XMLOutputProcessor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class ContentUnpacker {
    private static final String MIXINS_PROPERTY = "jcr:mixinTypes";
    private static final String PRIMARYTYPE_PROPERTY = "jcr:primaryType";
    private static final Namespace JCR_NAMESPACE = Namespace.getNamespace((String)"jcr", (String)"http://www.jcp.org/jcr/1.0");
    private static final Namespace CQ_NAMESPACE = Namespace.getNamespace((String)"cq", (String)"http://www.day.com/jcr/cq/1.0");
    private static final Pattern FILENAME_NAMESPACE_PATTERN = Pattern.compile("^([^:]+):(.+)$");
    private static final SAXParserFactory SAX_PARSER_FACTORY = SAXParserFactory.newInstance();
    private final Pattern[] excludeFiles;
    private final Pattern[] excludeNodes;
    private final Pattern[] excludeProperties;
    private final Pattern[] excludeMixins;
    private final boolean markReplicationActivated;
    private final Pattern[] markReplicationActivatedIncludeNodes;
    private final String dateLastReplicated;

    public ContentUnpacker(ContentUnpackerProperties properties) {
        this.excludeFiles = ContentUnpacker.toPatternArray(properties.getExcludeFiles());
        this.excludeNodes = ContentUnpacker.toPatternArray(properties.getExcludeNodes());
        this.excludeProperties = ContentUnpacker.toPatternArray(properties.getExcludeProperties());
        this.excludeMixins = ContentUnpacker.toPatternArray(properties.getExcludeMixins());
        this.markReplicationActivated = properties.isMarkReplicationActivated();
        this.markReplicationActivatedIncludeNodes = ContentUnpacker.toPatternArray(properties.getMarkReplicationActivatedIncludeNodes());
        if (StringUtils.isNotBlank((CharSequence)properties.getDateLastReplicated())) {
            this.dateLastReplicated = properties.getDateLastReplicated();
        } else {
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            this.dateLastReplicated = ISO8601.format((Calendar)cal);
        }
    }

    private static Pattern[] toPatternArray(String[] patternStrings) {
        if (patternStrings == null) {
            return new Pattern[0];
        }
        Pattern[] patterns = new Pattern[patternStrings.length];
        for (int i = 0; i < patternStrings.length; ++i) {
            try {
                patterns[i] = Pattern.compile(patternStrings[i]);
                continue;
            }
            catch (PatternSyntaxException ex) {
                throw new PackageManagerException("Invalid regexp pattern: " + patternStrings[i], ex);
            }
        }
        return patterns;
    }

    private static boolean matches(String name, Pattern[] patterns, boolean defaultIfNotPatternsDefined) {
        if (patterns.length == 0) {
            return defaultIfNotPatternsDefined;
        }
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean applyXmlExcludes(String name) {
        if (this.excludeNodes.length == 0 && this.excludeProperties.length == 0) {
            return false;
        }
        return StringUtils.endsWith((CharSequence)name, (CharSequence)".xml");
    }

    public void unpack(File file, File outputDirectory) {
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry entry = (ZipArchiveEntry)entries.nextElement();
                if (ContentUnpacker.matches(entry.getName(), this.excludeFiles, false)) continue;
                this.unpackEntry(zipFile, entry, outputDirectory);
            }
        }
        catch (IOException ex) {
            throw new PackageManagerException("Error reading content package " + file.getAbsolutePath(), ex);
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    private void unpackEntry(ZipFile zipFile, ZipArchiveEntry entry, File outputDirectory) throws IOException {
        block18: {
            if (entry.isDirectory()) {
                File directory = FileUtils.getFile((File)outputDirectory, (String[])new String[]{entry.getName()});
                directory.mkdirs();
            } else {
                Set<String> namespacePrefixes = null;
                if (this.applyXmlExcludes(entry.getName())) {
                    namespacePrefixes = this.getNamespacePrefixes(zipFile, entry);
                }
                try (InputStream entryStream = zipFile.getInputStream(entry);){
                    File outputFile = FileUtils.getFile((File)outputDirectory, (String[])new String[]{entry.getName()});
                    if (outputFile.exists()) {
                        outputFile.delete();
                    }
                    File directory = outputFile.getParentFile();
                    directory.mkdirs();
                    try (FileOutputStream fos = new FileOutputStream(outputFile);){
                        if (this.applyXmlExcludes(entry.getName()) && namespacePrefixes != null) {
                            try {
                                this.writeXmlWithExcludes(entry, entryStream, fos, namespacePrefixes);
                                break block18;
                            }
                            catch (JDOMException ex) {
                                throw new PackageManagerException("Unable to parse XML file: " + entry.getName(), ex);
                            }
                        }
                        IOUtils.copy((InputStream)entryStream, (OutputStream)fos);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> getNamespacePrefixes(ZipFile zipFile, ZipArchiveEntry entry) throws IOException {
        try (InputStream entryStream = zipFile.getInputStream(entry);){
            SAXParser parser = SAX_PARSER_FACTORY.newSAXParser();
            final LinkedHashSet<String> prefixes = new LinkedHashSet<String>();
            final AtomicBoolean foundRootElement = new AtomicBoolean(false);
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (StringUtils.equals((CharSequence)uri, (CharSequence)JCR_NAMESPACE.getURI()) && StringUtils.equals((CharSequence)localName, (CharSequence)"root")) {
                        foundRootElement.set(true);
                    }
                }

                @Override
                public void startPrefixMapping(String prefix, String uri) throws SAXException {
                    if (StringUtils.isNotBlank((CharSequence)prefix)) {
                        prefixes.add(prefix);
                    }
                }
            };
            parser.parse(entryStream, handler);
            if (!foundRootElement.get()) {
                Set<String> set = null;
                return set;
            }
            LinkedHashSet<String> linkedHashSet = prefixes;
            return linkedHashSet;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new IOException("Error parsing " + entry.getName(), ex);
        }
    }

    private void writeXmlWithExcludes(ZipArchiveEntry entry, InputStream inputStream, OutputStream outputStream, Set<String> namespacePrefixes) throws IOException, JDOMException {
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)"");
        saxBuilder.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", (Object)"");
        Document doc = saxBuilder.build(inputStream);
        HashSet<String> namespacePrefixesActuallyUsed = new HashSet<String>();
        String namespacePrefix = ContentUnpacker.getNamespacePrefix(entry.getName());
        if (namespacePrefix != null) {
            namespacePrefixesActuallyUsed.add(namespacePrefix);
        }
        this.applyXmlExcludes(doc.getRootElement(), this.getParentPath(entry), namespacePrefixesActuallyUsed, false);
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat().setIndent("    ").setLineSeparator(LineSeparator.UNIX));
        outputter.setXMLOutputProcessor((XMLOutputProcessor)new OneAttributePerLineXmlProcessor(namespacePrefixes, namespacePrefixesActuallyUsed));
        outputter.output(doc, outputStream);
        outputStream.flush();
    }

    static String getNamespacePrefix(String path) {
        String nodeName;
        Matcher matcher;
        String parentFolderName;
        String fileName = FilenameUtils.getName((String)path);
        if (StringUtils.equals((CharSequence)".content.xml", (CharSequence)fileName) && (parentFolderName = FilenameUtils.getName((String)FilenameUtils.getPathNoEndSeparator((String)path))) != null && (matcher = FILENAME_NAMESPACE_PATTERN.matcher(nodeName = PlatformNameFormat.getRepositoryName((String)parentFolderName))).matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getParentPath(ZipArchiveEntry entry) {
        return StringUtils.removeEnd((String)StringUtils.removeStart((String)entry.getName(), (String)"jcr_root"), (String)"/.content.xml");
    }

    private String buildElementPath(Element element, String parentPath) {
        StringBuilder path = new StringBuilder(parentPath);
        if (!StringUtils.equals((CharSequence)element.getQualifiedName(), (CharSequence)"jcr:root")) {
            path.append("/").append(element.getQualifiedName());
        }
        return path.toString();
    }

    private void applyXmlExcludes(Element element, String parentPath, Set<String> namespacePrefixesActuallyUsed, boolean insideReplicationElement) {
        String path = this.buildElementPath(element, parentPath);
        if (ContentUnpacker.matches(path, this.excludeNodes, false)) {
            element.detach();
            return;
        }
        this.collectNamespacePrefix(namespacePrefixesActuallyUsed, element.getNamespacePrefix());
        String jcrPrimaryType = element.getAttributeValue("primaryType", JCR_NAMESPACE);
        boolean isRepositoryUserGroup = StringUtils.equals((CharSequence)jcrPrimaryType, (CharSequence)"rep:User") || StringUtils.equals((CharSequence)jcrPrimaryType, (CharSequence)"rep:Group");
        boolean isReplicationElement = StringUtils.equals((CharSequence)jcrPrimaryType, (CharSequence)"cq:Page") || StringUtils.equals((CharSequence)jcrPrimaryType, (CharSequence)"dam:Asset") || StringUtils.equals((CharSequence)jcrPrimaryType, (CharSequence)"cq:Template");
        boolean isContent = insideReplicationElement && StringUtils.equals((CharSequence)element.getQualifiedName(), (CharSequence)"jcr:content");
        boolean setReplicationAttributes = isContent && this.markReplicationActivated;
        ArrayList attributes = new ArrayList(element.getAttributes());
        for (Attribute attribute : attributes) {
            boolean excluded = false;
            if (ContentUnpacker.matches(attribute.getQualifiedName(), this.excludeProperties, false)) {
                if (!isRepositoryUserGroup || !StringUtils.equals((CharSequence)attribute.getQualifiedName(), (CharSequence)"jcr:uuid")) {
                    attribute.detach();
                    excluded = true;
                }
            } else if (StringUtils.equals((CharSequence)attribute.getQualifiedName(), (CharSequence)PRIMARYTYPE_PROPERTY)) {
                String namespacePrefix = StringUtils.substringBefore((String)attribute.getValue(), (String)":");
                this.collectNamespacePrefix(namespacePrefixesActuallyUsed, namespacePrefix);
            } else if (StringUtils.equals((CharSequence)attribute.getQualifiedName(), (CharSequence)MIXINS_PROPERTY)) {
                String filteredValue = this.filterMixinsPropertyValue(attribute.getValue(), namespacePrefixesActuallyUsed);
                if (StringUtils.isBlank((CharSequence)filteredValue)) {
                    attribute.detach();
                } else {
                    attribute.setValue(filteredValue);
                }
            } else if (StringUtils.startsWith((CharSequence)attribute.getValue(), (CharSequence)"{Name}")) {
                this.collectNamespacePrefixNameArray(namespacePrefixesActuallyUsed, attribute.getQualifiedName(), attribute.getValue());
                attribute.setValue(this.sortReferenceValues(attribute.getQualifiedName(), attribute.getValue(), 7));
            } else if (StringUtils.startsWith((CharSequence)attribute.getValue(), (CharSequence)"{WeakReference}")) {
                attribute.setValue(this.sortReferenceValues(attribute.getQualifiedName(), attribute.getValue(), 10));
            }
            if (excluded) continue;
            this.collectNamespacePrefix(namespacePrefixesActuallyUsed, attribute.getNamespacePrefix());
        }
        if (setReplicationAttributes && ContentUnpacker.matches(path, this.markReplicationActivatedIncludeNodes, true)) {
            this.addMixin(element, "cq:ReplicationStatus");
            element.setAttribute("lastReplicated", "{Date}" + this.dateLastReplicated, CQ_NAMESPACE);
            element.setAttribute("lastReplicationAction", "Activate", CQ_NAMESPACE);
            this.collectNamespacePrefix(namespacePrefixesActuallyUsed, CQ_NAMESPACE.getPrefix());
        }
        ArrayList children = new ArrayList(element.getChildren());
        for (Element child : children) {
            this.applyXmlExcludes(child, path, namespacePrefixesActuallyUsed, (insideReplicationElement || isReplicationElement) && !isContent);
        }
    }

    private String filterMixinsPropertyValue(String value, Set<String> namespacePrefixesActuallyUsed) {
        if (this.excludeMixins.length == 0 || StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        DocViewProperty prop = DocViewProperty.parse((String)MIXINS_PROPERTY, (String)value);
        ArrayList<MockValue> mixins = new ArrayList<MockValue>();
        for (int i = 0; i < prop.values.length; ++i) {
            String mixin = prop.values[i];
            if (ContentUnpacker.matches(mixin, this.excludeMixins, false)) continue;
            String namespacePrefix = StringUtils.substringBefore((String)mixin, (String)":");
            this.collectNamespacePrefix(namespacePrefixesActuallyUsed, namespacePrefix);
            mixins.add(new MockValue(mixin, 1));
        }
        if (mixins.isEmpty()) {
            return null;
        }
        try {
            return DocViewProperty.format((Property)new MockProperty(MIXINS_PROPERTY, true, mixins.toArray(new Value[0])));
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Unable to format value for jcr:mixinTypes", ex);
        }
    }

    private void addMixin(Element element, String mixin) {
        String mixinsString = element.getAttributeValue("mixinTypes", JCR_NAMESPACE);
        ArrayList<String> mixins = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)mixinsString)) {
            DocViewProperty prop = DocViewProperty.parse((String)MIXINS_PROPERTY, (String)mixinsString);
            for (int i = 0; i < prop.values.length; ++i) {
                mixins.add(prop.values[i]);
            }
        }
        if (!mixins.contains(mixin)) {
            mixins.add(mixin);
        }
        try {
            Value[] values = (Value[])mixins.stream().map(item -> new MockValue((String)item, 1)).toArray(Value[]::new);
            mixinsString = DocViewProperty.format((Property)new MockProperty(MIXINS_PROPERTY, true, values));
            element.setAttribute("mixinTypes", mixinsString, JCR_NAMESPACE);
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Unable to format value for jcr:mixinTypes", ex);
        }
    }

    private void collectNamespacePrefix(Set<String> prefixes, String prefix) {
        if (StringUtils.isNotBlank((CharSequence)prefix)) {
            prefixes.add(prefix);
        }
    }

    private void collectNamespacePrefixNameArray(Set<String> prefixes, String name, String value) {
        DocViewProperty prop = DocViewProperty.parse((String)name, (String)value);
        for (int i = 0; i < prop.values.length; ++i) {
            String item = prop.values[i];
            String namespacePrefix = StringUtils.substringBefore((String)item, (String)":");
            this.collectNamespacePrefix(prefixes, namespacePrefix);
        }
    }

    private String sortReferenceValues(String name, String value, int propertyType) {
        TreeSet<String> refs = new TreeSet<String>();
        DocViewProperty prop = DocViewProperty.parse((String)name, (String)value);
        for (int i = 0; i < prop.values.length; ++i) {
            refs.add(prop.values[i]);
        }
        ArrayList<MockValue> values = new ArrayList<MockValue>();
        for (String ref : refs) {
            values.add(new MockValue(ref, propertyType));
        }
        try {
            return DocViewProperty.format((Property)new MockProperty(name, true, values.toArray(new Value[0])));
        }
        catch (RepositoryException ex) {
            throw new RuntimeException("Unable to format value for " + name, ex);
        }
    }

    static {
        SAX_PARSER_FACTORY.setNamespaceAware(true);
    }

    private static class MockValue
    implements Value {
        private final String value;
        private final int type;

        MockValue(String value, int type) {
            this.value = value;
            this.type = type;
        }

        public String getString() {
            return this.value;
        }

        public int getType() {
            return this.type;
        }

        public InputStream getStream() {
            throw new UnsupportedOperationException();
        }

        public Binary getBinary() {
            throw new UnsupportedOperationException();
        }

        public long getLong() {
            throw new UnsupportedOperationException();
        }

        public double getDouble() {
            throw new UnsupportedOperationException();
        }

        public BigDecimal getDecimal() {
            throw new UnsupportedOperationException();
        }

        public Calendar getDate() {
            throw new UnsupportedOperationException();
        }

        public boolean getBoolean() {
            throw new UnsupportedOperationException();
        }
    }

    private static class MockProperty
    implements Property,
    PropertyDefinition {
        private final String name;
        private final boolean multiple;
        private final Value[] values;

        MockProperty(String name, boolean multiple, Value[] values) {
            this.name = name;
            this.multiple = multiple;
            this.values = values;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            if (this.values.length > 0) {
                return this.values[0].getType();
            }
            return 0;
        }

        public boolean isMultiple() {
            return this.multiple;
        }

        public Value getValue() throws ValueFormatException {
            if (this.multiple) {
                throw new ValueFormatException("Property is multiple.");
            }
            return this.values[0];
        }

        public Value[] getValues() throws ValueFormatException {
            if (!this.multiple) {
                throw new ValueFormatException("Property is not multiple.");
            }
            return this.values;
        }

        public PropertyDefinition getDefinition() {
            return this;
        }

        public String getPath() {
            throw new UnsupportedOperationException();
        }

        public Item getAncestor(int depth) {
            throw new UnsupportedOperationException();
        }

        public Node getParent() {
            throw new UnsupportedOperationException();
        }

        public int getDepth() {
            throw new UnsupportedOperationException();
        }

        public Session getSession() {
            throw new UnsupportedOperationException();
        }

        public boolean isNode() {
            throw new UnsupportedOperationException();
        }

        public boolean isNew() {
            throw new UnsupportedOperationException();
        }

        public boolean isModified() {
            throw new UnsupportedOperationException();
        }

        public boolean isSame(Item otherItem) {
            throw new UnsupportedOperationException();
        }

        public void accept(ItemVisitor visitor) {
            throw new UnsupportedOperationException();
        }

        public void save() {
            throw new UnsupportedOperationException();
        }

        public void refresh(boolean keepChanges) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void setValue(Value value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Value[] value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(String[] value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(InputStream value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Binary value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(long value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(double value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(BigDecimal value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Calendar value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(boolean value) {
            throw new UnsupportedOperationException();
        }

        public void setValue(Node value) {
            throw new UnsupportedOperationException();
        }

        public String getString() {
            throw new UnsupportedOperationException();
        }

        public InputStream getStream() {
            throw new UnsupportedOperationException();
        }

        public Binary getBinary() {
            throw new UnsupportedOperationException();
        }

        public long getLong() {
            throw new UnsupportedOperationException();
        }

        public double getDouble() {
            throw new UnsupportedOperationException();
        }

        public BigDecimal getDecimal() {
            throw new UnsupportedOperationException();
        }

        public Calendar getDate() {
            throw new UnsupportedOperationException();
        }

        public boolean getBoolean() {
            throw new UnsupportedOperationException();
        }

        public Node getNode() {
            throw new UnsupportedOperationException();
        }

        public Property getProperty() {
            throw new UnsupportedOperationException();
        }

        public long getLength() {
            throw new UnsupportedOperationException();
        }

        public long[] getLengths() {
            throw new UnsupportedOperationException();
        }

        public NodeType getDeclaringNodeType() {
            throw new UnsupportedOperationException();
        }

        public boolean isAutoCreated() {
            throw new UnsupportedOperationException();
        }

        public boolean isMandatory() {
            throw new UnsupportedOperationException();
        }

        public int getOnParentVersion() {
            throw new UnsupportedOperationException();
        }

        public boolean isProtected() {
            throw new UnsupportedOperationException();
        }

        public int getRequiredType() {
            throw new UnsupportedOperationException();
        }

        public String[] getValueConstraints() {
            throw new UnsupportedOperationException();
        }

        public Value[] getDefaultValues() {
            throw new UnsupportedOperationException();
        }

        public String[] getAvailableQueryOperators() {
            throw new UnsupportedOperationException();
        }

        public boolean isFullTextSearchable() {
            throw new UnsupportedOperationException();
        }

        public boolean isQueryOrderable() {
            throw new UnsupportedOperationException();
        }
    }
}

