/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.unpack;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.support.AbstractXMLOutputProcessor;
import org.jdom2.output.support.FormatStack;
import org.jdom2.output.support.Walker;
import org.jdom2.util.NamespaceStack;

class OneAttributePerLineXmlProcessor
extends AbstractXMLOutputProcessor {
    private final Set<String> namespacePrefixes;
    private final Set<String> namespacePrefixesActuallyUsed;

    OneAttributePerLineXmlProcessor(Set<String> namespacePrefixes, Set<String> namespacePrefixesActuallyUsed) {
        this.namespacePrefixes = namespacePrefixes;
        this.namespacePrefixesActuallyUsed = namespacePrefixesActuallyUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printElement(Writer out, FormatStack fstack, NamespaceStack nstack, Element element) throws IOException {
        nstack.push(element);
        try {
            List content = element.getContent();
            this.write(out, "<");
            this.write(out, element.getQualifiedName());
            ArrayList<Namespace> definedNamespaces = new ArrayList<Namespace>();
            for (Namespace namespace : nstack.addedForward()) {
                definedNamespaces.add(namespace);
            }
            block10: for (String string : this.namespacePrefixes) {
                for (int i = 0; i < definedNamespaces.size(); ++i) {
                    Namespace ns = (Namespace)definedNamespaces.get(i);
                    if (!StringUtils.equals((CharSequence)string, (CharSequence)ns.getPrefix())) continue;
                    if (this.namespacePrefixesActuallyUsed.contains(ns.getPrefix())) {
                        this.printNamespace(out, fstack, ns);
                    }
                    definedNamespaces.remove(i);
                    continue block10;
                }
            }
            for (Namespace namespace : definedNamespaces) {
                if (!this.namespacePrefixesActuallyUsed.contains(namespace.getPrefix())) continue;
                this.printNamespace(out, fstack, namespace);
            }
            if (element.hasAttributes()) {
                boolean printMultiLine = element.getAttributes().size() > 1 || nstack.addedForward().iterator().hasNext();
                for (Attribute attribute : element.getAttributes()) {
                    this.printAttribute(out, fstack, attribute, printMultiLine);
                }
            }
            if (content.isEmpty()) {
                if (fstack.isExpandEmptyElements()) {
                    this.write(out, "></");
                    this.write(out, element.getQualifiedName());
                    this.write(out, ">");
                } else {
                    this.write(out, "/>");
                }
                return;
            }
            fstack.push();
            try {
                String space = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
                if ("default".equals(space)) {
                    fstack.setTextMode(fstack.getDefaultMode());
                } else if ("preserve".equals(space)) {
                    fstack.setTextMode(Format.TextMode.PRESERVE);
                }
                Walker walker = this.buildWalker(fstack, content, true);
                if (!walker.hasNext()) {
                    if (fstack.isExpandEmptyElements()) {
                        this.write(out, "></");
                        this.write(out, element.getQualifiedName());
                        this.write(out, ">");
                    } else {
                        this.write(out, "/>");
                    }
                    return;
                }
                this.write(out, ">");
                if (!walker.isAllText()) {
                    this.textRaw(out, fstack.getPadBetween());
                }
                this.printContent(out, fstack, nstack, walker);
                if (!walker.isAllText()) {
                    this.textRaw(out, fstack.getPadLast());
                }
                this.write(out, "</");
                this.write(out, element.getQualifiedName());
                this.write(out, ">");
            }
            finally {
                fstack.pop();
            }
        }
        finally {
            nstack.pop();
        }
    }

    private void printAttribute(Writer out, FormatStack fstack, Attribute attribute, boolean printMultiLine) throws IOException {
        if (!attribute.isSpecified() && fstack.isSpecifiedAttributesOnly()) {
            return;
        }
        if (printMultiLine) {
            this.write(out, StringUtils.defaultString((String)fstack.getLineSeparator()));
            this.write(out, StringUtils.defaultString((String)fstack.getLevelIndent()));
            this.write(out, StringUtils.defaultString((String)fstack.getIndent()));
        } else {
            this.write(out, " ");
        }
        this.write(out, attribute.getQualifiedName());
        this.write(out, "=");
        this.write(out, "\"");
        this.attributeEscapedEntitiesFilter(out, fstack, attribute.getValue());
        this.write(out, "\"");
    }
}

