/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public final class ContentPackageProperties {
    private static final String ZIP_ENTRY_PROPERTIES = "META-INF/vault/properties.xml";

    private ContentPackageProperties() {
    }

    public static Map<String, Object> get(File packageFile) throws IOException {
        try (ZipFile zipFile = new ZipFile(packageFile);){
            ZipArchiveEntry entry = zipFile.getEntry(ZIP_ENTRY_PROPERTIES);
            if (entry != null && !entry.isDirectory()) {
                Map<String, Object> props = ContentPackageProperties.getPackageProperties(zipFile, entry);
                TreeMap<String, Object> treeMap = new TreeMap<String, Object>(ContentPackageProperties.transformPropertyTypes(props));
                return treeMap;
            }
            Map<String, Object> map = Collections.emptyMap();
            return map;
        }
    }

    private static Map<String, Object> getPackageProperties(ZipFile zipFile, ZipArchiveEntry entry) throws IOException {
        try (InputStream entryStream = zipFile.getInputStream(entry);){
            Properties props = new Properties();
            props.loadFromXML(entryStream);
            Properties properties = props;
            return properties;
        }
    }

    private static Map<String, Object> transformPropertyTypes(Map<String, Object> props) {
        HashMap<String, Object> transformedProps = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : props.entrySet()) {
            transformedProps.put(entry.getKey(), ContentPackageProperties.transformType(entry.getValue()));
        }
        return transformedProps;
    }

    private static Object transformType(Object value) {
        boolean boolValue;
        if (value == null) {
            return null;
        }
        String valueString = value.toString();
        if (StringUtils.equals((CharSequence)valueString, (CharSequence)Boolean.toString(boolValue = BooleanUtils.toBoolean((String)valueString)))) {
            return boolValue;
        }
        int intValue = NumberUtils.toInt((String)valueString);
        if (StringUtils.equals((CharSequence)valueString, (CharSequence)Integer.toString(intValue))) {
            return intValue;
        }
        return value;
    }
}

