/*
 * Decompiled with CFR 0.152.
 */
package io.wcm.tooling.commons.packmgr.util;

import io.wcm.tooling.commons.packmgr.PackageManagerProperties;
import io.wcm.tooling.commons.packmgr.install.PackageFile;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;

public final class HttpClientUtil {
    private HttpClientUtil() {
    }

    public static RequestConfig buildRequestConfig(PackageManagerProperties props) {
        return RequestConfig.custom().setConnectTimeout(props.getHttpConnectTimeoutSec() * 1000).setSocketTimeout(props.getHttpSocketTimeoutSec() * 1000).build();
    }

    public static void applyRequestConfig(HttpRequestBase httpRequest, PackageFile packageFile, PackageManagerProperties props) {
        Integer httpSocketTimeoutSec = packageFile.getHttpSocketTimeoutSec();
        if (httpSocketTimeoutSec == null) {
            return;
        }
        RequestConfig defaultConfig = HttpClientUtil.buildRequestConfig(props);
        httpRequest.setConfig(RequestConfig.copy((RequestConfig)defaultConfig).setSocketTimeout(httpSocketTimeoutSec * 1000).build());
    }
}

