/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.SortArgument;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;

public class SortArguments
implements Argument {
    private final SortArgument[] sort;

    @Override
    public String build() {
        if (ArrayUtils.isNotEmpty((Object[])this.sort)) {
            return String.format("sort:[%s]", Arrays.stream(this.sort).map(SortArgument::build).collect(Collectors.joining(", ")));
        }
        return "sort:[]";
    }

    SortArguments(SortArgument[] sort) {
        this.sort = sort;
    }

    public static SortArgumentsBuilder builder() {
        return new SortArgumentsBuilder();
    }

    public SortArgument[] getSort() {
        return this.sort;
    }

    public String toString() {
        return "SortArguments(sort=" + Arrays.deepToString(this.getSort()) + ")";
    }

    public static class SortArgumentsBuilder {
        private SortArgument[] sort;

        SortArgumentsBuilder() {
        }

        public SortArgumentsBuilder sort(SortArgument[] sort) {
            this.sort = sort;
            return this;
        }

        public SortArguments build() {
            return new SortArguments(this.sort);
        }

        public String toString() {
            return "SortArguments.SortArgumentsBuilder(sort=" + Arrays.deepToString(this.sort) + ")";
        }
    }
}

