/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Arrays;
import java.util.LinkedHashSet;

public class Bm25Argument
implements Argument {
    private final String query;
    private final String[] properties;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        arg.add(String.format("query:%s", Serializer.quote(this.query)));
        if (this.properties != null) {
            arg.add(String.format("properties:%s", Serializer.arrayWithQuotes(this.properties)));
        }
        return String.format("bm25:{%s}", String.join((CharSequence)" ", arg));
    }

    Bm25Argument(String query, String[] properties) {
        this.query = query;
        this.properties = properties;
    }

    public static Bm25ArgumentBuilder builder() {
        return new Bm25ArgumentBuilder();
    }

    public String getQuery() {
        return this.query;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public String toString() {
        return "Bm25Argument(query=" + this.getQuery() + ", properties=" + Arrays.deepToString(this.getProperties()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bm25Argument)) {
            return false;
        }
        Bm25Argument other = (Bm25Argument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        return Arrays.deepEquals(this.getProperties(), other.getProperties());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Bm25Argument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getProperties());
        return result;
    }

    public static class Bm25ArgumentBuilder {
        private String query;
        private String[] properties;

        Bm25ArgumentBuilder() {
        }

        public Bm25ArgumentBuilder query(String query) {
            this.query = query;
            return this;
        }

        public Bm25ArgumentBuilder properties(String[] properties) {
            this.properties = properties;
            return this;
        }

        public Bm25Argument build() {
            return new Bm25Argument(this.query, this.properties);
        }

        public String toString() {
            return "Bm25Argument.Bm25ArgumentBuilder(query=" + this.query + ", properties=" + Arrays.deepToString(this.properties) + ")";
        }
    }
}

