/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client;

import io.weaviate.client.Config;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.http.builder.HttpApacheClientBuilder;
import io.weaviate.client.base.http.impl.CommonsHttpClientImpl;
import io.weaviate.client.base.util.DbVersionProvider;
import io.weaviate.client.base.util.DbVersionSupport;
import io.weaviate.client.base.util.GrpcVersionSupport;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import io.weaviate.client.v1.backup.Backup;
import io.weaviate.client.v1.batch.Batch;
import io.weaviate.client.v1.classifications.Classifications;
import io.weaviate.client.v1.cluster.Cluster;
import io.weaviate.client.v1.contextionary.Contextionary;
import io.weaviate.client.v1.data.Data;
import io.weaviate.client.v1.graphql.GraphQL;
import io.weaviate.client.v1.misc.Misc;
import io.weaviate.client.v1.misc.api.MetaGetter;
import io.weaviate.client.v1.misc.model.Meta;
import io.weaviate.client.v1.schema.Schema;
import java.util.Optional;

public class WeaviateClient {
    private final Config config;
    private final DbVersionProvider dbVersionProvider;
    private final DbVersionSupport dbVersionSupport;
    private final GrpcVersionSupport grpcVersionSupport;
    private final HttpClient httpClient;
    private final AccessTokenProvider tokenProvider;

    public WeaviateClient(Config config) {
        this(config, new CommonsHttpClientImpl(config.getHeaders(), null, HttpApacheClientBuilder.build(config)), null);
    }

    public WeaviateClient(Config config, AccessTokenProvider tokenProvider) {
        this(config, new CommonsHttpClientImpl(config.getHeaders(), tokenProvider, HttpApacheClientBuilder.build(config)), tokenProvider);
    }

    public WeaviateClient(Config config, HttpClient httpClient, AccessTokenProvider tokenProvider) {
        this.config = config;
        this.httpClient = httpClient;
        this.dbVersionProvider = this.initDbVersionProvider();
        this.dbVersionSupport = new DbVersionSupport(this.dbVersionProvider);
        this.grpcVersionSupport = new GrpcVersionSupport(this.dbVersionProvider);
        this.tokenProvider = tokenProvider;
    }

    public Misc misc() {
        return new Misc(this.httpClient, this.config, this.dbVersionProvider);
    }

    public Schema schema() {
        return new Schema(this.httpClient, this.config);
    }

    public Data data() {
        this.dbVersionProvider.refresh();
        return new Data(this.httpClient, this.config, this.dbVersionSupport);
    }

    public Batch batch() {
        this.dbVersionProvider.refresh();
        return new Batch(this.httpClient, this.config, this.dbVersionSupport, this.grpcVersionSupport, this.tokenProvider, this.data());
    }

    public Backup backup() {
        return new Backup(this.httpClient, this.config);
    }

    public Contextionary c11y() {
        return new Contextionary(this.httpClient, this.config);
    }

    public Classifications classifications() {
        return new Classifications(this.httpClient, this.config);
    }

    public Cluster cluster() {
        return new Cluster(this.httpClient, this.config);
    }

    public GraphQL graphQL() {
        return new GraphQL(this.httpClient, this.config);
    }

    private DbVersionProvider initDbVersionProvider() {
        MetaGetter metaGetter = new Misc(this.httpClient, this.config, null).metaGetter();
        DbVersionProvider.VersionGetter getter = () -> Optional.ofNullable(metaGetter.run()).filter(result -> !result.hasErrors()).map(result -> ((Meta)result.getResult()).getVersion());
        return new DbVersionProvider(getter);
    }
}

