/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.data.model;

import io.weaviate.client.v1.data.model.Deprecation;
import io.weaviate.client.v1.data.model.WeaviateObject;
import java.util.Arrays;

public class ObjectsListResponse {
    private final Deprecation[] deprecations;
    private final WeaviateObject[] objects;
    private final int totalResults;

    ObjectsListResponse(Deprecation[] deprecations, WeaviateObject[] objects, int totalResults) {
        this.deprecations = deprecations;
        this.objects = objects;
        this.totalResults = totalResults;
    }

    public static ObjectsListResponseBuilder builder() {
        return new ObjectsListResponseBuilder();
    }

    public Deprecation[] getDeprecations() {
        return this.deprecations;
    }

    public WeaviateObject[] getObjects() {
        return this.objects;
    }

    public int getTotalResults() {
        return this.totalResults;
    }

    public String toString() {
        return "ObjectsListResponse(deprecations=" + Arrays.deepToString(this.getDeprecations()) + ", objects=" + Arrays.deepToString(this.getObjects()) + ", totalResults=" + this.getTotalResults() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObjectsListResponse)) {
            return false;
        }
        ObjectsListResponse other = (ObjectsListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotalResults() != other.getTotalResults()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getDeprecations(), other.getDeprecations())) {
            return false;
        }
        return Arrays.deepEquals(this.getObjects(), other.getObjects());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObjectsListResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getTotalResults();
        result = result * 59 + Arrays.deepHashCode(this.getDeprecations());
        result = result * 59 + Arrays.deepHashCode(this.getObjects());
        return result;
    }

    public static class ObjectsListResponseBuilder {
        private Deprecation[] deprecations;
        private WeaviateObject[] objects;
        private int totalResults;

        ObjectsListResponseBuilder() {
        }

        public ObjectsListResponseBuilder deprecations(Deprecation[] deprecations) {
            this.deprecations = deprecations;
            return this;
        }

        public ObjectsListResponseBuilder objects(WeaviateObject[] objects) {
            this.objects = objects;
            return this;
        }

        public ObjectsListResponseBuilder totalResults(int totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public ObjectsListResponse build() {
            return new ObjectsListResponse(this.deprecations, this.objects, this.totalResults);
        }

        public String toString() {
            return "ObjectsListResponse.ObjectsListResponseBuilder(deprecations=" + Arrays.deepToString(this.deprecations) + ", objects=" + Arrays.deepToString(this.objects) + ", totalResults=" + this.totalResults + ")";
        }
    }
}

