/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.util;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class Serializer {
    private Serializer() {
    }

    public static String escape(String input) {
        if (input == null) {
            return "";
        }
        return StringEscapeUtils.escapeJava((String)input);
    }

    public static String quote(String input) {
        if (input == null) {
            return "";
        }
        if (input.equals("")) {
            return "\"\"";
        }
        return StringUtils.wrap((String)Serializer.escape(input), (String)"\"");
    }

    public static String arrayWithQuotes(String[] input) {
        return Serializer.array(input, Serializer::quote);
    }

    public static <T> String array(T[] input) {
        return Serializer.array(input, i -> i);
    }

    public static <T, R> String array(T[] input, Function<T, R> mapper) {
        String inner = "";
        if (input != null) {
            inner = Arrays.stream(input).map(mapper).map(Objects::toString).collect(Collectors.joining(","));
        }
        return "[" + inner + "]";
    }
}

