// Generated by delombok at Mon Jan 08 10:19:26 UTC 2024
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.util.Serializer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import java.util.LinkedHashSet;
import java.util.Set;

public class NearTextArgument implements Argument {
  private final String[] concepts;
  private final Float certainty;
  private final Float distance;
  private final NearTextMoveParameters moveTo;
  private final NearTextMoveParameters moveAwayFrom;
  private final Boolean autocorrect;

  private String buildMoveParam(String name, NearTextMoveParameters moveParam) {
    Set<String> arg = new LinkedHashSet<>();
    if (ArrayUtils.isNotEmpty(moveParam.getConcepts())) {
      arg.add(String.format("concepts:%s", Serializer.arrayWithQuotes(moveParam.getConcepts())));
    }
    if (moveParam.getForce() != null) {
      arg.add(String.format("force:%s", moveParam.getForce()));
    }
    if (ArrayUtils.isNotEmpty(moveParam.getObjects())) {
      arg.add(String.format("objects:%s", Serializer.array(moveParam.getObjects(), this::mapObjectMoveToStringClause)));
    }
    return String.format("%s:{%s}", name, String.join(" ", arg));
  }

  private String mapObjectMoveToStringClause(NearTextMoveParameters.ObjectMove obj) {
    Set<String> objectsArg = new LinkedHashSet<>();
    if (StringUtils.isNotBlank(obj.getId())) {
      objectsArg.add(String.format("id:%s", Serializer.quote(obj.getId())));
    }
    if (StringUtils.isNotBlank(obj.getBeacon())) {
      objectsArg.add(String.format("beacon:%s", Serializer.quote(obj.getBeacon())));
    }
    return String.format("{%s}", String.join(" ", objectsArg));
  }

  @Override
  public String build() {
    Set<String> arg = new LinkedHashSet<>();
    if (ArrayUtils.isNotEmpty(concepts)) {
      arg.add(String.format("concepts:%s", Serializer.arrayWithQuotes(concepts)));
    }
    if (certainty != null) {
      arg.add(String.format("certainty:%s", certainty));
    }
    if (distance != null) {
      arg.add(String.format("distance:%s", distance));
    }
    if (moveTo != null) {
      arg.add(buildMoveParam("moveTo", moveTo));
    }
    if (moveAwayFrom != null) {
      arg.add(buildMoveParam("moveAwayFrom", moveAwayFrom));
    }
    if (autocorrect != null) {
      arg.add(String.format("autocorrect:%s", autocorrect));
    }
    return String.format("nearText:{%s}", String.join(" ", arg));
  }

  @java.lang.SuppressWarnings("all")
  NearTextArgument(final String[] concepts, final Float certainty, final Float distance, final NearTextMoveParameters moveTo, final NearTextMoveParameters moveAwayFrom, final Boolean autocorrect) {
    this.concepts = concepts;
    this.certainty = certainty;
    this.distance = distance;
    this.moveTo = moveTo;
    this.moveAwayFrom = moveAwayFrom;
    this.autocorrect = autocorrect;
  }


  @java.lang.SuppressWarnings("all")
  public static class NearTextArgumentBuilder {
    @java.lang.SuppressWarnings("all")
    private String[] concepts;
    @java.lang.SuppressWarnings("all")
    private Float certainty;
    @java.lang.SuppressWarnings("all")
    private Float distance;
    @java.lang.SuppressWarnings("all")
    private NearTextMoveParameters moveTo;
    @java.lang.SuppressWarnings("all")
    private NearTextMoveParameters moveAwayFrom;
    @java.lang.SuppressWarnings("all")
    private Boolean autocorrect;

    @java.lang.SuppressWarnings("all")
    NearTextArgumentBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearTextArgument.NearTextArgumentBuilder concepts(final String[] concepts) {
      this.concepts = concepts;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearTextArgument.NearTextArgumentBuilder certainty(final Float certainty) {
      this.certainty = certainty;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearTextArgument.NearTextArgumentBuilder distance(final Float distance) {
      this.distance = distance;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearTextArgument.NearTextArgumentBuilder moveTo(final NearTextMoveParameters moveTo) {
      this.moveTo = moveTo;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearTextArgument.NearTextArgumentBuilder moveAwayFrom(final NearTextMoveParameters moveAwayFrom) {
      this.moveAwayFrom = moveAwayFrom;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearTextArgument.NearTextArgumentBuilder autocorrect(final Boolean autocorrect) {
      this.autocorrect = autocorrect;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public NearTextArgument build() {
      return new NearTextArgument(this.concepts, this.certainty, this.distance, this.moveTo, this.moveAwayFrom, this.autocorrect);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "NearTextArgument.NearTextArgumentBuilder(concepts=" + java.util.Arrays.deepToString(this.concepts) + ", certainty=" + this.certainty + ", distance=" + this.distance + ", moveTo=" + this.moveTo + ", moveAwayFrom=" + this.moveAwayFrom + ", autocorrect=" + this.autocorrect + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  public static NearTextArgument.NearTextArgumentBuilder builder() {
    return new NearTextArgument.NearTextArgumentBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String[] getConcepts() {
    return this.concepts;
  }

  @java.lang.SuppressWarnings("all")
  public Float getCertainty() {
    return this.certainty;
  }

  @java.lang.SuppressWarnings("all")
  public Float getDistance() {
    return this.distance;
  }

  @java.lang.SuppressWarnings("all")
  public NearTextMoveParameters getMoveTo() {
    return this.moveTo;
  }

  @java.lang.SuppressWarnings("all")
  public NearTextMoveParameters getMoveAwayFrom() {
    return this.moveAwayFrom;
  }

  @java.lang.SuppressWarnings("all")
  public Boolean getAutocorrect() {
    return this.autocorrect;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "NearTextArgument(concepts=" + java.util.Arrays.deepToString(this.getConcepts()) + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", moveTo=" + this.getMoveTo() + ", moveAwayFrom=" + this.getMoveAwayFrom() + ", autocorrect=" + this.getAutocorrect() + ")";
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof NearTextArgument)) return false;
    final NearTextArgument other = (NearTextArgument) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$certainty = this.getCertainty();
    final java.lang.Object other$certainty = other.getCertainty();
    if (this$certainty == null ? other$certainty != null : !this$certainty.equals(other$certainty)) return false;
    final java.lang.Object this$distance = this.getDistance();
    final java.lang.Object other$distance = other.getDistance();
    if (this$distance == null ? other$distance != null : !this$distance.equals(other$distance)) return false;
    final java.lang.Object this$autocorrect = this.getAutocorrect();
    final java.lang.Object other$autocorrect = other.getAutocorrect();
    if (this$autocorrect == null ? other$autocorrect != null : !this$autocorrect.equals(other$autocorrect)) return false;
    if (!java.util.Arrays.deepEquals(this.getConcepts(), other.getConcepts())) return false;
    final java.lang.Object this$moveTo = this.getMoveTo();
    final java.lang.Object other$moveTo = other.getMoveTo();
    if (this$moveTo == null ? other$moveTo != null : !this$moveTo.equals(other$moveTo)) return false;
    final java.lang.Object this$moveAwayFrom = this.getMoveAwayFrom();
    final java.lang.Object other$moveAwayFrom = other.getMoveAwayFrom();
    if (this$moveAwayFrom == null ? other$moveAwayFrom != null : !this$moveAwayFrom.equals(other$moveAwayFrom)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof NearTextArgument;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $certainty = this.getCertainty();
    result = result * PRIME + ($certainty == null ? 43 : $certainty.hashCode());
    final java.lang.Object $distance = this.getDistance();
    result = result * PRIME + ($distance == null ? 43 : $distance.hashCode());
    final java.lang.Object $autocorrect = this.getAutocorrect();
    result = result * PRIME + ($autocorrect == null ? 43 : $autocorrect.hashCode());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getConcepts());
    final java.lang.Object $moveTo = this.getMoveTo();
    result = result * PRIME + ($moveTo == null ? 43 : $moveTo.hashCode());
    final java.lang.Object $moveAwayFrom = this.getMoveAwayFrom();
    result = result * PRIME + ($moveAwayFrom == null ? 43 : $moveAwayFrom.hashCode());
    return result;
  }
}
