// Generated by delombok at Mon Jan 08 10:19:26 UTC 2024
package io.weaviate.client.v1.graphql.query.fields;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class Field implements Argument {
  private final String name;
  private final Field[] fields;

  @Override
  public String build() {
    StringBuilder s = new StringBuilder();
    if (StringUtils.isNotBlank(name)) {
      s.append(name);
    }
    if (ArrayUtils.isNotEmpty(fields)) {
      s.append(String.format("{%s}", Arrays.stream(fields).map(Field::build).collect(Collectors.joining(" "))));
    }
    return s.toString();
  }

  // created to accept a variable number of fields
  public static class FieldBuilder {
    @java.lang.SuppressWarnings("all")
    private String name;
    private Field[] fields;

    public FieldBuilder fields(Field... fields) {
      this.fields = fields;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    FieldBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public Field.FieldBuilder name(final String name) {
      this.name = name;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public Field build() {
      return new Field(this.name, this.fields);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "Field.FieldBuilder(name=" + this.name + ", fields=" + java.util.Arrays.deepToString(this.fields) + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  Field(final String name, final Field[] fields) {
    this.name = name;
    this.fields = fields;
  }

  @java.lang.SuppressWarnings("all")
  public static Field.FieldBuilder builder() {
    return new Field.FieldBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public String getName() {
    return this.name;
  }

  @java.lang.SuppressWarnings("all")
  public Field[] getFields() {
    return this.fields;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "Field(name=" + this.getName() + ", fields=" + java.util.Arrays.deepToString(this.getFields()) + ")";
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof Field)) return false;
    final Field other = (Field) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$name = this.getName();
    final java.lang.Object other$name = other.getName();
    if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
    if (!java.util.Arrays.deepEquals(this.getFields(), other.getFields())) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof Field;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $name = this.getName();
    result = result * PRIME + ($name == null ? 43 : $name.hashCode());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getFields());
    return result;
  }
}
