/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.batch.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import io.weaviate.client.base.util.CrossReference;
import io.weaviate.client.base.util.GrpcVersionSupport;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoBase;
import io.weaviate.client.grpc.protocol.v1.WeaviateProtoBatch;
import io.weaviate.client.v1.data.model.WeaviateObject;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class BatchObjectConverter {
    protected static final int BYTES_PER_FLOAT = 4;
    private final GrpcVersionSupport grpcVersionSupport;

    public WeaviateProtoBatch.BatchObject toBatchObject(WeaviateObject obj) {
        WeaviateProtoBatch.BatchObject.Builder builder = WeaviateProtoBatch.BatchObject.newBuilder();
        if (obj.getId() != null) {
            builder.setUuid(obj.getId());
        }
        if (obj.getClassName() != null) {
            builder.setCollection(obj.getClassName());
        }
        if (obj.getVector() != null) {
            if (this.grpcVersionSupport.supportsVectorBytesField()) {
                ByteBuffer buffer = ByteBuffer.allocate(obj.getVector().length * 4).order(ByteOrder.LITTLE_ENDIAN);
                Arrays.stream(obj.getVector()).forEach(buffer::putFloat);
                builder.setVectorBytes(ByteString.copyFrom((byte[])buffer.array()));
            } else {
                builder.addAllVector(Arrays.asList(obj.getVector()));
            }
        }
        if (obj.getTenant() != null) {
            builder.setTenant(obj.getTenant());
        }
        if (obj.getProperties() != null) {
            builder.setProperties(BatchObjectConverter.buildProperties(obj.getProperties()));
        }
        return builder.build();
    }

    private static WeaviateProtoBatch.BatchObject.Properties buildProperties(Map<String, Object> properties) {
        WeaviateProtoBatch.BatchObject.Properties.Builder builder = WeaviateProtoBatch.BatchObject.Properties.newBuilder();
        Properties props = BatchObjectConverter.extractProperties(properties, true);
        builder.setNonRefProperties(Struct.newBuilder().putAllFields(props.nonRefProperties).build());
        props.numberArrayProperties.forEach(builder::addNumberArrayProperties);
        props.intArrayProperties.forEach(builder::addIntArrayProperties);
        props.textArrayProperties.forEach(builder::addTextArrayProperties);
        props.booleanArrayProperties.forEach(builder::addBooleanArrayProperties);
        props.objectProperties.forEach(builder::addObjectProperties);
        props.objectArrayProperties.forEach(builder::addObjectArrayProperties);
        props.singleTargetRefProps.forEach(builder::addSingleTargetRefProps);
        props.multiTargetRefProps.forEach(builder::addMultiTargetRefProps);
        return builder.build();
    }

    private static Properties extractProperties(Map<String, Object> properties, boolean rootLevel) {
        HashMap<String, Value> nonRefProperties = new HashMap<String, Value>();
        ArrayList<WeaviateProtoBase.NumberArrayProperties> numberArrayProperties = new ArrayList<WeaviateProtoBase.NumberArrayProperties>();
        ArrayList<WeaviateProtoBase.IntArrayProperties> intArrayProperties = new ArrayList<WeaviateProtoBase.IntArrayProperties>();
        ArrayList<WeaviateProtoBase.TextArrayProperties> textArrayProperties = new ArrayList<WeaviateProtoBase.TextArrayProperties>();
        ArrayList<WeaviateProtoBase.BooleanArrayProperties> booleanArrayProperties = new ArrayList<WeaviateProtoBase.BooleanArrayProperties>();
        ArrayList<WeaviateProtoBase.ObjectProperties> objectProperties = new ArrayList<WeaviateProtoBase.ObjectProperties>();
        ArrayList<WeaviateProtoBase.ObjectArrayProperties> objectArrayProperties = new ArrayList<WeaviateProtoBase.ObjectArrayProperties>();
        ArrayList<WeaviateProtoBatch.BatchObject.SingleTargetRefProps> singleTargetRefProps = new ArrayList<WeaviateProtoBatch.BatchObject.SingleTargetRefProps>();
        ArrayList<WeaviateProtoBatch.BatchObject.MultiTargetRefProps> multiTargetRefProps = new ArrayList<WeaviateProtoBatch.BatchObject.MultiTargetRefProps>();
        for (Map.Entry<String, Object> e : properties.entrySet()) {
            List value;
            String propName = e.getKey();
            Object propValue = e.getValue();
            if (propValue instanceof String) {
                nonRefProperties.put(propName, Value.newBuilder().setStringValue((String)propValue).build());
                continue;
            }
            if (propValue instanceof Boolean) {
                nonRefProperties.put(propName, Value.newBuilder().setBoolValue(((Boolean)propValue).booleanValue()).build());
                continue;
            }
            if (propValue instanceof Integer) {
                nonRefProperties.put(propName, Value.newBuilder().setNumberValue(((Integer)propValue).doubleValue()).build());
                continue;
            }
            if (propValue instanceof Long) {
                nonRefProperties.put(propName, Value.newBuilder().setNumberValue(((Long)propValue).doubleValue()).build());
                continue;
            }
            if (propValue instanceof Float) {
                nonRefProperties.put(propName, Value.newBuilder().setNumberValue(((Float)propValue).doubleValue()).build());
                continue;
            }
            if (propValue instanceof Double) {
                nonRefProperties.put(propName, Value.newBuilder().setNumberValue(((Double)propValue).doubleValue()).build());
                continue;
            }
            if (propValue instanceof String[]) {
                WeaviateProtoBase.TextArrayProperties textArrayProps = WeaviateProtoBase.TextArrayProperties.newBuilder().setPropName(propName).addAllValues(Arrays.asList((String[])propValue)).build();
                textArrayProperties.add(textArrayProps);
                continue;
            }
            if (propValue instanceof Boolean[]) {
                WeaviateProtoBase.BooleanArrayProperties booleanArrayProps = WeaviateProtoBase.BooleanArrayProperties.newBuilder().setPropName(propName).addAllValues(Arrays.asList((Boolean[])propValue)).build();
                booleanArrayProperties.add(booleanArrayProps);
                continue;
            }
            if (propValue instanceof Integer[]) {
                value = Arrays.stream((Integer[])propValue).map(Integer::longValue).collect(Collectors.toList());
                WeaviateProtoBase.IntArrayProperties intArrayProps = WeaviateProtoBase.IntArrayProperties.newBuilder().setPropName(propName).addAllValues(value).build();
                intArrayProperties.add(intArrayProps);
                continue;
            }
            if (propValue instanceof Long[]) {
                WeaviateProtoBase.IntArrayProperties intArrayProps = WeaviateProtoBase.IntArrayProperties.newBuilder().setPropName(propName).addAllValues(Arrays.asList((Long[])propValue)).build();
                intArrayProperties.add(intArrayProps);
                continue;
            }
            if (propValue instanceof Float[]) {
                value = Arrays.stream((Float[])propValue).map(Float::doubleValue).collect(Collectors.toList());
                WeaviateProtoBase.NumberArrayProperties numberArrayProps = WeaviateProtoBase.NumberArrayProperties.newBuilder().setPropName(propName).addAllValues(value).build();
                numberArrayProperties.add(numberArrayProps);
                continue;
            }
            if (propValue instanceof Double[]) {
                WeaviateProtoBase.NumberArrayProperties numberArrayProps = WeaviateProtoBase.NumberArrayProperties.newBuilder().setPropName(propName).addAllValues(Arrays.asList((Double[])propValue)).build();
                numberArrayProperties.add(numberArrayProps);
                continue;
            }
            if (propValue instanceof Map) {
                Properties extractedProperties = BatchObjectConverter.extractProperties((Map)propValue, false);
                WeaviateProtoBase.ObjectPropertiesValue.Builder objectPropertiesValue = WeaviateProtoBase.ObjectPropertiesValue.newBuilder();
                objectPropertiesValue.setNonRefProperties(Struct.newBuilder().putAllFields(extractedProperties.nonRefProperties).build());
                extractedProperties.numberArrayProperties.forEach(objectPropertiesValue::addNumberArrayProperties);
                extractedProperties.intArrayProperties.forEach(objectPropertiesValue::addIntArrayProperties);
                extractedProperties.textArrayProperties.forEach(objectPropertiesValue::addTextArrayProperties);
                extractedProperties.booleanArrayProperties.forEach(objectPropertiesValue::addBooleanArrayProperties);
                extractedProperties.objectProperties.forEach(objectPropertiesValue::addObjectProperties);
                extractedProperties.objectArrayProperties.forEach(objectPropertiesValue::addObjectArrayProperties);
                WeaviateProtoBase.ObjectProperties objectProps = WeaviateProtoBase.ObjectProperties.newBuilder().setPropName(propName).setValue(objectPropertiesValue.build()).build();
                objectProperties.add(objectProps);
                continue;
            }
            if (!(propValue instanceof List)) continue;
            if (BatchObjectConverter.isCrossReference((List)propValue, rootLevel)) {
                List<String> beacons = BatchObjectConverter.extractBeacons((List)propValue);
                List crossReferences = beacons.stream().map(CrossReference::fromBeacon).collect(Collectors.toList());
                HashMap<String, ArrayList<String>> crefs = new HashMap<String, ArrayList<String>>();
                Iterator<Object> iterator = crossReferences.iterator();
                while (iterator.hasNext()) {
                    CrossReference crossReference = (CrossReference)iterator.next();
                    ArrayList<String> uuids = (ArrayList<String>)crefs.get(crossReference.getClassName());
                    if (uuids == null) {
                        uuids = new ArrayList<String>();
                    }
                    uuids.add(crossReference.getTargetID());
                    crefs.put(crossReference.getClassName(), uuids);
                }
                if (crefs.size() == 1) {
                    for (Map.Entry entry : crefs.entrySet()) {
                        WeaviateProtoBatch.BatchObject.SingleTargetRefProps singleTargetCrossRefs = WeaviateProtoBatch.BatchObject.SingleTargetRefProps.newBuilder().setPropName(propName).addAllUuids((Iterable)entry.getValue()).build();
                        singleTargetRefProps.add(singleTargetCrossRefs);
                    }
                }
                if (crefs.size() <= 1) continue;
                for (Map.Entry entry : crefs.entrySet()) {
                    WeaviateProtoBatch.BatchObject.MultiTargetRefProps multiTargetCrossRefs = WeaviateProtoBatch.BatchObject.MultiTargetRefProps.newBuilder().setPropName(propName).addAllUuids((Iterable)entry.getValue()).setTargetCollection((String)entry.getKey()).build();
                    multiTargetRefProps.add(multiTargetCrossRefs);
                }
                continue;
            }
            ArrayList<WeaviateProtoBase.ObjectPropertiesValue> objectPropertiesValues = new ArrayList<WeaviateProtoBase.ObjectPropertiesValue>();
            for (Object propValueObject : (List)propValue) {
                if (!(propValueObject instanceof Map)) continue;
                Properties extractedProperties = BatchObjectConverter.extractProperties((Map)propValueObject, false);
                WeaviateProtoBase.ObjectPropertiesValue.Builder builder = WeaviateProtoBase.ObjectPropertiesValue.newBuilder();
                builder.setNonRefProperties(Struct.newBuilder().putAllFields(extractedProperties.nonRefProperties).build());
                extractedProperties.numberArrayProperties.forEach(builder::addNumberArrayProperties);
                extractedProperties.intArrayProperties.forEach(builder::addIntArrayProperties);
                extractedProperties.textArrayProperties.forEach(builder::addTextArrayProperties);
                extractedProperties.booleanArrayProperties.forEach(builder::addBooleanArrayProperties);
                extractedProperties.objectProperties.forEach(builder::addObjectProperties);
                extractedProperties.objectArrayProperties.forEach(builder::addObjectArrayProperties);
                objectPropertiesValues.add(builder.build());
            }
            WeaviateProtoBase.ObjectArrayProperties objectArrayProps = WeaviateProtoBase.ObjectArrayProperties.newBuilder().setPropName(propName).addAllValues(objectPropertiesValues).build();
            objectArrayProperties.add(objectArrayProps);
        }
        return new Properties(nonRefProperties, numberArrayProperties, intArrayProperties, textArrayProperties, booleanArrayProperties, objectProperties, objectArrayProperties, singleTargetRefProps, multiTargetRefProps);
    }

    private static boolean isCrossReference(List<?> propValue, boolean rootLevel) {
        if (rootLevel) {
            for (Object element : propValue) {
                Map valueMap;
                if (!(element instanceof Map) || (valueMap = (Map)element).size() <= 1 && (valueMap.size() != 1 || valueMap.get("beacon") != null && valueMap.get("beacon") instanceof String)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static List<String> extractBeacons(List<?> propValue) {
        ArrayList<String> beacons = new ArrayList<String>();
        for (Object element : propValue) {
            if (!(element instanceof Map)) continue;
            Map valueMap = (Map)element;
            beacons.add((String)valueMap.get("beacon"));
        }
        return beacons;
    }

    public BatchObjectConverter(GrpcVersionSupport grpcVersionSupport) {
        this.grpcVersionSupport = grpcVersionSupport;
    }

    private static class Properties {
        private Map<String, Value> nonRefProperties;
        private List<WeaviateProtoBase.NumberArrayProperties> numberArrayProperties;
        private List<WeaviateProtoBase.IntArrayProperties> intArrayProperties;
        private List<WeaviateProtoBase.TextArrayProperties> textArrayProperties;
        private List<WeaviateProtoBase.BooleanArrayProperties> booleanArrayProperties;
        private List<WeaviateProtoBase.ObjectProperties> objectProperties;
        private List<WeaviateProtoBase.ObjectArrayProperties> objectArrayProperties;
        private List<WeaviateProtoBatch.BatchObject.SingleTargetRefProps> singleTargetRefProps;
        private List<WeaviateProtoBatch.BatchObject.MultiTargetRefProps> multiTargetRefProps;

        public Properties(Map<String, Value> nonRefProperties, List<WeaviateProtoBase.NumberArrayProperties> numberArrayProperties, List<WeaviateProtoBase.IntArrayProperties> intArrayProperties, List<WeaviateProtoBase.TextArrayProperties> textArrayProperties, List<WeaviateProtoBase.BooleanArrayProperties> booleanArrayProperties, List<WeaviateProtoBase.ObjectProperties> objectProperties, List<WeaviateProtoBase.ObjectArrayProperties> objectArrayProperties, List<WeaviateProtoBatch.BatchObject.SingleTargetRefProps> singleTargetRefProps, List<WeaviateProtoBatch.BatchObject.MultiTargetRefProps> multiTargetRefProps) {
            this.nonRefProperties = nonRefProperties;
            this.numberArrayProperties = numberArrayProperties;
            this.intArrayProperties = intArrayProperties;
            this.textArrayProperties = textArrayProperties;
            this.booleanArrayProperties = booleanArrayProperties;
            this.objectProperties = objectProperties;
            this.objectArrayProperties = objectArrayProperties;
            this.singleTargetRefProps = singleTargetRefProps;
            this.multiTargetRefProps = multiTargetRefProps;
        }

        public String toString() {
            return "BatchObjectConverter.Properties(nonRefProperties=" + this.nonRefProperties + ", numberArrayProperties=" + this.numberArrayProperties + ", intArrayProperties=" + this.intArrayProperties + ", textArrayProperties=" + this.textArrayProperties + ", booleanArrayProperties=" + this.booleanArrayProperties + ", objectProperties=" + this.objectProperties + ", objectArrayProperties=" + this.objectArrayProperties + ", singleTargetRefProps=" + this.singleTargetRefProps + ", multiTargetRefProps=" + this.multiTargetRefProps + ")";
        }
    }
}

