/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.batch.util;

import io.weaviate.client.base.util.TriConsumer;
import io.weaviate.client.base.util.UrlEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class ReferencesPath {
    public String buildCreate(Params params) {
        return this.build(params, this::addQueryConsistencyLevel);
    }

    @SafeVarargs
    private final String build(Params params, TriConsumer<Params, List<String>, List<String>> ... appenders) {
        Objects.requireNonNull(params);
        ArrayList<String> pathParams = new ArrayList<String>();
        ArrayList queryParams = new ArrayList();
        pathParams.add("/batch/references");
        Arrays.stream(appenders).forEach(consumer -> consumer.accept(params, pathParams, queryParams));
        String path = String.join((CharSequence)"/", pathParams);
        if (!queryParams.isEmpty()) {
            return path + "?" + String.join((CharSequence)"&", queryParams);
        }
        return path;
    }

    private void addQueryConsistencyLevel(Params params, List<String> pathParams, List<String> queryParams) {
        if (StringUtils.isNotBlank((CharSequence)params.consistencyLevel)) {
            queryParams.add(UrlEncoder.encodeQueryParam("consistency_level", params.consistencyLevel));
        }
    }

    public static class Params {
        private final String consistencyLevel;

        Params(String consistencyLevel) {
            this.consistencyLevel = consistencyLevel;
        }

        public static ParamsBuilder builder() {
            return new ParamsBuilder();
        }

        public String toString() {
            return "ReferencesPath.Params(consistencyLevel=" + this.consistencyLevel + ")";
        }

        public static class ParamsBuilder {
            private String consistencyLevel;

            ParamsBuilder() {
            }

            public ParamsBuilder consistencyLevel(String consistencyLevel) {
                this.consistencyLevel = consistencyLevel;
                return this;
            }

            public Params build() {
                return new Params(this.consistencyLevel);
            }

            public String toString() {
                return "ReferencesPath.Params.ParamsBuilder(consistencyLevel=" + this.consistencyLevel + ")";
            }
        }
    }
}

