/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.fields;

import io.weaviate.client.v1.graphql.query.fields.Field;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class GenerativeSearchBuilder {
    private final String singleResultPrompt;
    private final String groupedResultTask;
    private final String[] groupedResultProperties;

    public Field build() {
        LinkedHashSet<String> nameParts = new LinkedHashSet<String>();
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)this.singleResultPrompt)) {
            nameParts.add(String.format("singleResult:{prompt:\"\"%s\"\"}", Serializer.quote(this.singleResultPrompt)));
            fieldNames.add("singleResult");
        }
        if (StringUtils.isNotBlank((CharSequence)this.groupedResultTask) || ArrayUtils.isNotEmpty((Object[])this.groupedResultProperties)) {
            LinkedHashSet<String> argParts = new LinkedHashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)this.groupedResultTask)) {
                argParts.add(String.format("task:\"\"%s\"\"", Serializer.quote(this.groupedResultTask)));
            }
            if (ArrayUtils.isNotEmpty((Object[])this.groupedResultProperties)) {
                argParts.add(String.format("properties:%s", Serializer.arrayWithQuotes(this.groupedResultProperties)));
            }
            nameParts.add(String.format("groupedResult:{%s}", StringUtils.join(argParts, (String)" ")));
            fieldNames.add("groupedResult");
        }
        if (nameParts.isEmpty()) {
            return Field.builder().build();
        }
        fieldNames.add("error");
        String name = String.format("generate(%s)", String.join((CharSequence)" ", nameParts));
        Field[] fields = (Field[])fieldNames.stream().map(n -> Field.builder().name((String)n).build()).toArray(Field[]::new);
        return Field.builder().name(name).fields(fields).build();
    }

    GenerativeSearchBuilder(String singleResultPrompt, String groupedResultTask, String[] groupedResultProperties) {
        this.singleResultPrompt = singleResultPrompt;
        this.groupedResultTask = groupedResultTask;
        this.groupedResultProperties = groupedResultProperties;
    }

    public static GenerativeSearchBuilderBuilder builder() {
        return new GenerativeSearchBuilderBuilder();
    }

    public String getSingleResultPrompt() {
        return this.singleResultPrompt;
    }

    public String getGroupedResultTask() {
        return this.groupedResultTask;
    }

    public String[] getGroupedResultProperties() {
        return this.groupedResultProperties;
    }

    public String toString() {
        return "GenerativeSearchBuilder(singleResultPrompt=" + this.getSingleResultPrompt() + ", groupedResultTask=" + this.getGroupedResultTask() + ", groupedResultProperties=" + Arrays.deepToString(this.getGroupedResultProperties()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenerativeSearchBuilder)) {
            return false;
        }
        GenerativeSearchBuilder other = (GenerativeSearchBuilder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$singleResultPrompt = this.getSingleResultPrompt();
        String other$singleResultPrompt = other.getSingleResultPrompt();
        if (this$singleResultPrompt == null ? other$singleResultPrompt != null : !this$singleResultPrompt.equals(other$singleResultPrompt)) {
            return false;
        }
        String this$groupedResultTask = this.getGroupedResultTask();
        String other$groupedResultTask = other.getGroupedResultTask();
        if (this$groupedResultTask == null ? other$groupedResultTask != null : !this$groupedResultTask.equals(other$groupedResultTask)) {
            return false;
        }
        return Arrays.deepEquals(this.getGroupedResultProperties(), other.getGroupedResultProperties());
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenerativeSearchBuilder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $singleResultPrompt = this.getSingleResultPrompt();
        result = result * 59 + ($singleResultPrompt == null ? 43 : $singleResultPrompt.hashCode());
        String $groupedResultTask = this.getGroupedResultTask();
        result = result * 59 + ($groupedResultTask == null ? 43 : $groupedResultTask.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getGroupedResultProperties());
        return result;
    }

    public static class GenerativeSearchBuilderBuilder {
        private String singleResultPrompt;
        private String groupedResultTask;
        private String[] groupedResultProperties;

        GenerativeSearchBuilderBuilder() {
        }

        public GenerativeSearchBuilderBuilder singleResultPrompt(String singleResultPrompt) {
            this.singleResultPrompt = singleResultPrompt;
            return this;
        }

        public GenerativeSearchBuilderBuilder groupedResultTask(String groupedResultTask) {
            this.groupedResultTask = groupedResultTask;
            return this;
        }

        public GenerativeSearchBuilderBuilder groupedResultProperties(String[] groupedResultProperties) {
            this.groupedResultProperties = groupedResultProperties;
            return this;
        }

        public GenerativeSearchBuilder build() {
            return new GenerativeSearchBuilder(this.singleResultPrompt, this.groupedResultTask, this.groupedResultProperties);
        }

        public String toString() {
            return "GenerativeSearchBuilder.GenerativeSearchBuilderBuilder(singleResultPrompt=" + this.singleResultPrompt + ", groupedResultTask=" + this.groupedResultTask + ", groupedResultProperties=" + Arrays.deepToString(this.groupedResultProperties) + ")";
        }
    }
}

