/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class HybridArgument
implements Argument {
    private final String query;
    private final Float alpha;
    private final Float[] vector;
    private final String fusionType;
    private final String[] properties;
    private final String[] targetVectors;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        arg.add(String.format("query:%s", Serializer.quote(this.query)));
        if (this.vector != null) {
            arg.add(String.format("vector:%s", Serializer.array(this.vector)));
        }
        if (this.alpha != null) {
            arg.add(String.format("alpha:%s", this.alpha));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.properties)) {
            arg.add(String.format("properties:%s", Serializer.arrayWithQuotes(this.properties)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.fusionType)) {
            arg.add(String.format("fusionType:%s", this.fusionType));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.targetVectors)) {
            arg.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(this.targetVectors)));
        }
        return String.format("hybrid:{%s}", String.join((CharSequence)" ", arg));
    }

    HybridArgument(String query, Float alpha, Float[] vector, String fusionType, String[] properties, String[] targetVectors) {
        this.query = query;
        this.alpha = alpha;
        this.vector = vector;
        this.fusionType = fusionType;
        this.properties = properties;
        this.targetVectors = targetVectors;
    }

    public static HybridArgumentBuilder builder() {
        return new HybridArgumentBuilder();
    }

    public String getQuery() {
        return this.query;
    }

    public Float getAlpha() {
        return this.alpha;
    }

    public Float[] getVector() {
        return this.vector;
    }

    public String getFusionType() {
        return this.fusionType;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public String[] getTargetVectors() {
        return this.targetVectors;
    }

    public String toString() {
        return "HybridArgument(query=" + this.getQuery() + ", alpha=" + this.getAlpha() + ", vector=" + Arrays.deepToString(this.getVector()) + ", fusionType=" + this.getFusionType() + ", properties=" + Arrays.deepToString(this.getProperties()) + ", targetVectors=" + Arrays.deepToString(this.getTargetVectors()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HybridArgument)) {
            return false;
        }
        HybridArgument other = (HybridArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$alpha = this.getAlpha();
        Float other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !((Object)this$alpha).equals(other$alpha)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVector(), other.getVector())) {
            return false;
        }
        String this$fusionType = this.getFusionType();
        String other$fusionType = other.getFusionType();
        if (this$fusionType == null ? other$fusionType != null : !this$fusionType.equals(other$fusionType)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getProperties(), other.getProperties())) {
            return false;
        }
        return Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HybridArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : ((Object)$alpha).hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getVector());
        String $fusionType = this.getFusionType();
        result = result * 59 + ($fusionType == null ? 43 : $fusionType.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getProperties());
        result = result * 59 + Arrays.deepHashCode(this.getTargetVectors());
        return result;
    }

    public static class HybridArgumentBuilder {
        private String query;
        private Float alpha;
        private Float[] vector;
        private String fusionType;
        private String[] properties;
        private String[] targetVectors;

        HybridArgumentBuilder() {
        }

        public HybridArgumentBuilder query(String query) {
            this.query = query;
            return this;
        }

        public HybridArgumentBuilder alpha(Float alpha) {
            this.alpha = alpha;
            return this;
        }

        public HybridArgumentBuilder vector(Float[] vector) {
            this.vector = vector;
            return this;
        }

        public HybridArgumentBuilder fusionType(String fusionType) {
            this.fusionType = fusionType;
            return this;
        }

        public HybridArgumentBuilder properties(String[] properties) {
            this.properties = properties;
            return this;
        }

        public HybridArgumentBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        public HybridArgument build() {
            return new HybridArgument(this.query, this.alpha, this.vector, this.fusionType, this.properties, this.targetVectors);
        }

        public String toString() {
            return "HybridArgument.HybridArgumentBuilder(query=" + this.query + ", alpha=" + this.alpha + ", vector=" + Arrays.deepToString(this.vector) + ", fusionType=" + this.fusionType + ", properties=" + Arrays.deepToString(this.properties) + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ")";
        }
    }
}

