/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.NearTextMoveParameters;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class NearTextArgument
implements Argument {
    private final String[] concepts;
    private final Float certainty;
    private final Float distance;
    private final NearTextMoveParameters moveTo;
    private final NearTextMoveParameters moveAwayFrom;
    private final Boolean autocorrect;
    private final String[] targetVectors;

    private String buildMoveParam(String name, NearTextMoveParameters moveParam) {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (ArrayUtils.isNotEmpty((Object[])moveParam.getConcepts())) {
            arg.add(String.format("concepts:%s", Serializer.arrayWithQuotes(moveParam.getConcepts())));
        }
        if (moveParam.getForce() != null) {
            arg.add(String.format("force:%s", moveParam.getForce()));
        }
        if (ArrayUtils.isNotEmpty((Object[])moveParam.getObjects())) {
            arg.add(String.format("objects:%s", Serializer.array(moveParam.getObjects(), this::mapObjectMoveToStringClause)));
        }
        return String.format("%s:{%s}", name, String.join((CharSequence)" ", arg));
    }

    private String mapObjectMoveToStringClause(NearTextMoveParameters.ObjectMove obj) {
        LinkedHashSet<String> objectsArg = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)obj.getId())) {
            objectsArg.add(String.format("id:%s", Serializer.quote(obj.getId())));
        }
        if (StringUtils.isNotBlank((CharSequence)obj.getBeacon())) {
            objectsArg.add(String.format("beacon:%s", Serializer.quote(obj.getBeacon())));
        }
        return String.format("{%s}", String.join((CharSequence)" ", objectsArg));
    }

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (ArrayUtils.isNotEmpty((Object[])this.concepts)) {
            arg.add(String.format("concepts:%s", Serializer.arrayWithQuotes(this.concepts)));
        }
        if (this.certainty != null) {
            arg.add(String.format("certainty:%s", this.certainty));
        }
        if (this.distance != null) {
            arg.add(String.format("distance:%s", this.distance));
        }
        if (this.moveTo != null) {
            arg.add(this.buildMoveParam("moveTo", this.moveTo));
        }
        if (this.moveAwayFrom != null) {
            arg.add(this.buildMoveParam("moveAwayFrom", this.moveAwayFrom));
        }
        if (this.autocorrect != null) {
            arg.add(String.format("autocorrect:%s", this.autocorrect));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.targetVectors)) {
            arg.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(this.targetVectors)));
        }
        return String.format("nearText:{%s}", String.join((CharSequence)" ", arg));
    }

    NearTextArgument(String[] concepts, Float certainty, Float distance, NearTextMoveParameters moveTo, NearTextMoveParameters moveAwayFrom, Boolean autocorrect, String[] targetVectors) {
        this.concepts = concepts;
        this.certainty = certainty;
        this.distance = distance;
        this.moveTo = moveTo;
        this.moveAwayFrom = moveAwayFrom;
        this.autocorrect = autocorrect;
        this.targetVectors = targetVectors;
    }

    public static NearTextArgumentBuilder builder() {
        return new NearTextArgumentBuilder();
    }

    public String[] getConcepts() {
        return this.concepts;
    }

    public Float getCertainty() {
        return this.certainty;
    }

    public Float getDistance() {
        return this.distance;
    }

    public NearTextMoveParameters getMoveTo() {
        return this.moveTo;
    }

    public NearTextMoveParameters getMoveAwayFrom() {
        return this.moveAwayFrom;
    }

    public Boolean getAutocorrect() {
        return this.autocorrect;
    }

    public String[] getTargetVectors() {
        return this.targetVectors;
    }

    public String toString() {
        return "NearTextArgument(concepts=" + Arrays.deepToString(this.getConcepts()) + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", moveTo=" + this.getMoveTo() + ", moveAwayFrom=" + this.getMoveAwayFrom() + ", autocorrect=" + this.getAutocorrect() + ", targetVectors=" + Arrays.deepToString(this.getTargetVectors()) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NearTextArgument)) {
            return false;
        }
        NearTextArgument other = (NearTextArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$certainty = this.getCertainty();
        Float other$certainty = other.getCertainty();
        if (this$certainty == null ? other$certainty != null : !((Object)this$certainty).equals(other$certainty)) {
            return false;
        }
        Float this$distance = this.getDistance();
        Float other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        Boolean this$autocorrect = this.getAutocorrect();
        Boolean other$autocorrect = other.getAutocorrect();
        if (this$autocorrect == null ? other$autocorrect != null : !((Object)this$autocorrect).equals(other$autocorrect)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getConcepts(), other.getConcepts())) {
            return false;
        }
        NearTextMoveParameters this$moveTo = this.getMoveTo();
        NearTextMoveParameters other$moveTo = other.getMoveTo();
        if (this$moveTo == null ? other$moveTo != null : !((Object)this$moveTo).equals(other$moveTo)) {
            return false;
        }
        NearTextMoveParameters this$moveAwayFrom = this.getMoveAwayFrom();
        NearTextMoveParameters other$moveAwayFrom = other.getMoveAwayFrom();
        if (this$moveAwayFrom == null ? other$moveAwayFrom != null : !((Object)this$moveAwayFrom).equals(other$moveAwayFrom)) {
            return false;
        }
        return Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NearTextArgument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $certainty = this.getCertainty();
        result = result * 59 + ($certainty == null ? 43 : ((Object)$certainty).hashCode());
        Float $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        Boolean $autocorrect = this.getAutocorrect();
        result = result * 59 + ($autocorrect == null ? 43 : ((Object)$autocorrect).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getConcepts());
        NearTextMoveParameters $moveTo = this.getMoveTo();
        result = result * 59 + ($moveTo == null ? 43 : ((Object)$moveTo).hashCode());
        NearTextMoveParameters $moveAwayFrom = this.getMoveAwayFrom();
        result = result * 59 + ($moveAwayFrom == null ? 43 : ((Object)$moveAwayFrom).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTargetVectors());
        return result;
    }

    public static class NearTextArgumentBuilder {
        private String[] concepts;
        private Float certainty;
        private Float distance;
        private NearTextMoveParameters moveTo;
        private NearTextMoveParameters moveAwayFrom;
        private Boolean autocorrect;
        private String[] targetVectors;

        NearTextArgumentBuilder() {
        }

        public NearTextArgumentBuilder concepts(String[] concepts) {
            this.concepts = concepts;
            return this;
        }

        public NearTextArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        public NearTextArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        public NearTextArgumentBuilder moveTo(NearTextMoveParameters moveTo) {
            this.moveTo = moveTo;
            return this;
        }

        public NearTextArgumentBuilder moveAwayFrom(NearTextMoveParameters moveAwayFrom) {
            this.moveAwayFrom = moveAwayFrom;
            return this;
        }

        public NearTextArgumentBuilder autocorrect(Boolean autocorrect) {
            this.autocorrect = autocorrect;
            return this;
        }

        public NearTextArgumentBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        public NearTextArgument build() {
            return new NearTextArgument(this.concepts, this.certainty, this.distance, this.moveTo, this.moveAwayFrom, this.autocorrect, this.targetVectors);
        }

        public String toString() {
            return "NearTextArgument.NearTextArgumentBuilder(concepts=" + Arrays.deepToString(this.concepts) + ", certainty=" + this.certainty + ", distance=" + this.distance + ", moveTo=" + this.moveTo + ", moveAwayFrom=" + this.moveAwayFrom + ", autocorrect=" + this.autocorrect + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ")";
        }
    }
}

