/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query;

import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.v1.graphql.model.ExploreFields;
import io.weaviate.client.v1.graphql.model.GraphQLQuery;
import io.weaviate.client.v1.graphql.model.GraphQLResponse;
import io.weaviate.client.v1.graphql.query.argument.AskArgument;
import io.weaviate.client.v1.graphql.query.argument.NearAudioArgument;
import io.weaviate.client.v1.graphql.query.argument.NearDepthArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImageArgument;
import io.weaviate.client.v1.graphql.query.argument.NearImuArgument;
import io.weaviate.client.v1.graphql.query.argument.NearObjectArgument;
import io.weaviate.client.v1.graphql.query.argument.NearTextArgument;
import io.weaviate.client.v1.graphql.query.argument.NearThermalArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVectorArgument;
import io.weaviate.client.v1.graphql.query.argument.NearVideoArgument;
import io.weaviate.client.v1.graphql.query.builder.ExploreBuilder;

public class Explore
extends BaseClient<GraphQLResponse>
implements ClientResult<GraphQLResponse> {
    private final ExploreBuilder.ExploreBuilderBuilder exploreBuilder = ExploreBuilder.builder();

    public Explore(HttpClient httpClient, Config config) {
        super(httpClient, config);
    }

    public Explore withFields(ExploreFields ... fields) {
        this.exploreBuilder.fields(fields);
        return this;
    }

    public Explore withLimit(Integer limit) {
        this.exploreBuilder.limit(limit);
        return this;
    }

    public Explore withOffset(Integer offset) {
        this.exploreBuilder.offset(offset);
        return this;
    }

    public Explore withAsk(AskArgument ask) {
        this.exploreBuilder.withAskArgument(ask);
        return this;
    }

    public Explore withNearText(NearTextArgument nearText) {
        this.exploreBuilder.withNearText(nearText);
        return this;
    }

    public Explore withNearObject(NearObjectArgument nearObject) {
        this.exploreBuilder.withNearObjectFilter(nearObject);
        return this;
    }

    public Explore withNearVector(NearVectorArgument nearVector) {
        this.exploreBuilder.withNearVectorFilter(nearVector);
        return this;
    }

    public Explore withNearImage(NearImageArgument nearImage) {
        this.exploreBuilder.withNearImageFilter(nearImage);
        return this;
    }

    public Explore withNearAudio(NearAudioArgument nearAudio) {
        this.exploreBuilder.withNearAudioFilter(nearAudio);
        return this;
    }

    public Explore withNearVideo(NearVideoArgument nearVideo) {
        this.exploreBuilder.withNearVideoFilter(nearVideo);
        return this;
    }

    public Explore withNearDepth(NearDepthArgument nearDepth) {
        this.exploreBuilder.withNearDepthFilter(nearDepth);
        return this;
    }

    public Explore withNearThermal(NearThermalArgument nearThermal) {
        this.exploreBuilder.withNearThermalFilter(nearThermal);
        return this;
    }

    public Explore withNearImu(NearImuArgument nearImu) {
        this.exploreBuilder.withNearImuFilter(nearImu);
        return this;
    }

    @Override
    public Result<GraphQLResponse> run() {
        String exploreQuery = this.exploreBuilder.build().buildQuery();
        GraphQLQuery query = GraphQLQuery.builder().query(exploreQuery).build();
        Response<GraphQLResponse> resp = this.sendPostRequest("/graphql", query, GraphQLResponse.class);
        return new Result<GraphQLResponse>(resp);
    }
}

