/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Targets;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashSet;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

class NearMediaArgumentHelper {
    private final String mediaName;
    private final String mediaField;
    private final String data;
    private final File dataFile;
    private final Float certainty;
    private final Float distance;
    private final String[] targetVectors;
    private final Targets targets;

    public String build() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        String content = this.getContent();
        if (StringUtils.isNotBlank((CharSequence)content)) {
            fields.add(String.format("%s:%s", this.mediaField, Serializer.quote(content)));
        }
        if (this.certainty != null) {
            fields.add(String.format("certainty:%s", this.certainty));
        }
        if (this.distance != null) {
            fields.add(String.format("distance:%s", this.distance));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.targetVectors)) {
            fields.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(this.targetVectors)));
        }
        if (this.targets != null) {
            fields.add(String.format("%s", this.targets.build()));
        }
        return String.format("%s:{%s}", this.mediaName, String.join((CharSequence)" ", fields));
    }

    private String getContent() {
        if (StringUtils.isNotBlank((CharSequence)this.data)) {
            if (this.data.startsWith("data:")) {
                String base64 = ";base64,";
                return this.data.substring(this.data.indexOf(base64) + base64.length());
            }
            return this.data;
        }
        if (this.dataFile != null) {
            return this.readFile(this.dataFile);
        }
        return null;
    }

    private String readFile(File file) {
        try {
            byte[] content = Files.readAllBytes(Paths.get(file.toURI()));
            return Base64.getEncoder().encodeToString(content);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Generated
    NearMediaArgumentHelper(String mediaName, String mediaField, String data, File dataFile, Float certainty, Float distance, String[] targetVectors, Targets targets) {
        this.mediaName = mediaName;
        this.mediaField = mediaField;
        this.data = data;
        this.dataFile = dataFile;
        this.certainty = certainty;
        this.distance = distance;
        this.targetVectors = targetVectors;
        this.targets = targets;
    }

    @Generated
    public static NearMediaArgumentHelperBuilder builder() {
        return new NearMediaArgumentHelperBuilder();
    }

    @Generated
    public static class NearMediaArgumentHelperBuilder {
        @Generated
        private String mediaName;
        @Generated
        private String mediaField;
        @Generated
        private String data;
        @Generated
        private File dataFile;
        @Generated
        private Float certainty;
        @Generated
        private Float distance;
        @Generated
        private String[] targetVectors;
        @Generated
        private Targets targets;

        @Generated
        NearMediaArgumentHelperBuilder() {
        }

        @Generated
        public NearMediaArgumentHelperBuilder mediaName(String mediaName) {
            this.mediaName = mediaName;
            return this;
        }

        @Generated
        public NearMediaArgumentHelperBuilder mediaField(String mediaField) {
            this.mediaField = mediaField;
            return this;
        }

        @Generated
        public NearMediaArgumentHelperBuilder data(String data) {
            this.data = data;
            return this;
        }

        @Generated
        public NearMediaArgumentHelperBuilder dataFile(File dataFile) {
            this.dataFile = dataFile;
            return this;
        }

        @Generated
        public NearMediaArgumentHelperBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        @Generated
        public NearMediaArgumentHelperBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        @Generated
        public NearMediaArgumentHelperBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        @Generated
        public NearMediaArgumentHelperBuilder targets(Targets targets) {
            this.targets = targets;
            return this;
        }

        @Generated
        public NearMediaArgumentHelper build() {
            return new NearMediaArgumentHelper(this.mediaName, this.mediaField, this.data, this.dataFile, this.certainty, this.distance, this.targetVectors, this.targets);
        }

        @Generated
        public String toString() {
            return "NearMediaArgumentHelper.NearMediaArgumentHelperBuilder(mediaName=" + this.mediaName + ", mediaField=" + this.mediaField + ", data=" + this.data + ", dataFile=" + this.dataFile + ", certainty=" + this.certainty + ", distance=" + this.distance + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ", targets=" + this.targets + ")";
        }
    }
}

