/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.base.http.impl;

import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.http.HttpResponse;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpHead;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;

public class CommonsHttpClientImpl
implements HttpClient,
Closeable {
    private final Map<String, String> headers;
    private AccessTokenProvider tokenProvider;
    private final CloseableHttpClientBuilder clientBuilder;

    public CommonsHttpClientImpl(Map<String, String> headers, CloseableHttpClientBuilder clientBuilder) {
        this(headers, null, clientBuilder);
    }

    public CommonsHttpClientImpl(Map<String, String> headers, AccessTokenProvider tokenProvider, CloseableHttpClientBuilder clientBuilder) {
        this.headers = headers;
        this.clientBuilder = clientBuilder;
        this.tokenProvider = tokenProvider;
    }

    @Override
    public HttpResponse sendGetRequest(String url) throws Exception {
        return this.sendRequestWithoutPayload((BasicClassicHttpRequest)new HttpGet(url));
    }

    @Override
    public HttpResponse sendPostRequest(String url, String json) throws Exception {
        return this.sendRequestWithPayload((BasicClassicHttpRequest)new HttpPost(url), json);
    }

    @Override
    public HttpResponse sendPutRequest(String url, String json) throws Exception {
        return this.sendRequestWithPayload((BasicClassicHttpRequest)new HttpPut(url), json);
    }

    @Override
    public HttpResponse sendPatchRequest(String url, String json) throws Exception {
        return this.sendRequestWithPayload((BasicClassicHttpRequest)new HttpPatch(url), json);
    }

    @Override
    public HttpResponse sendDeleteRequest(String url, String json) throws Exception {
        if (json == null) {
            return this.sendRequestWithoutPayload((BasicClassicHttpRequest)new HttpDelete(url));
        }
        return this.sendRequestWithPayload((BasicClassicHttpRequest)new HttpDeleteWithBody(url), json);
    }

    @Override
    public HttpResponse sendHeadRequest(String url) throws Exception {
        return this.sendRequestWithoutPayload((BasicClassicHttpRequest)new HttpHead(url));
    }

    private HttpResponse sendRequestWithoutPayload(BasicClassicHttpRequest request) throws Exception {
        request.setHeader("Accept", (Object)"*/*");
        return this.sendRequest(request);
    }

    private HttpResponse sendRequestWithPayload(BasicClassicHttpRequest request, String jsonString) throws Exception {
        request.setHeader("Accept", (Object)"application/json");
        request.setHeader("Content-Type", (Object)"application/json");
        request.setEntity((HttpEntity)new StringEntity(jsonString, StandardCharsets.UTF_8));
        return this.sendRequest(request);
    }

    private HttpResponse sendRequest(BasicClassicHttpRequest request) throws Exception {
        if (this.headers != null && this.headers.size() > 0) {
            this.headers.forEach((arg_0, arg_1) -> ((BasicClassicHttpRequest)request).addHeader(arg_0, arg_1));
        }
        if (this.tokenProvider != null) {
            request.addHeader("Authorization", (Object)String.format("Bearer %s", this.tokenProvider.getAccessToken()));
        }
        CloseableHttpClient client = this.clientBuilder.build();
        CloseableHttpResponse response = client.execute((ClassicHttpRequest)request);
        int statusCode = response.getCode();
        String body = response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8) : "";
        client.close();
        return new HttpResponse(statusCode, body);
    }

    @Override
    public void close() throws IOException {
        if (this.tokenProvider != null) {
            this.tokenProvider.shutdown();
        }
    }

    public static interface CloseableHttpClientBuilder {
        public CloseableHttpClient build();
    }

    private static class HttpDeleteWithBody
    extends HttpUriRequestBase {
        public HttpDeleteWithBody(String url) {
            super("DELETE", URI.create(url));
        }
    }
}

