/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.argument.Argument;
import io.weaviate.client.v1.graphql.query.argument.Targets;
import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.Arrays;
import java.util.LinkedHashSet;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class NearObjectArgument
implements Argument {
    private final String id;
    private final String beacon;
    private final Float certainty;
    private final Float distance;
    private final String[] targetVectors;
    private final Targets targets;

    @Override
    public String build() {
        LinkedHashSet<String> arg = new LinkedHashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)this.id)) {
            arg.add(String.format("id:%s", Serializer.quote(this.id)));
        }
        if (StringUtils.isNotBlank((CharSequence)this.beacon)) {
            arg.add(String.format("beacon:%s", Serializer.quote(this.beacon)));
        }
        if (this.certainty != null) {
            arg.add(String.format("certainty:%s", this.certainty));
        }
        if (this.distance != null) {
            arg.add(String.format("distance:%s", this.distance));
        }
        if (ArrayUtils.isNotEmpty((Object[])this.targetVectors)) {
            arg.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(this.targetVectors)));
        }
        if (this.targets != null) {
            arg.add(String.format("%s", this.targets.build()));
        }
        return String.format("nearObject:{%s}", String.join((CharSequence)" ", arg));
    }

    @Generated
    NearObjectArgument(String id, String beacon, Float certainty, Float distance, String[] targetVectors, Targets targets) {
        this.id = id;
        this.beacon = beacon;
        this.certainty = certainty;
        this.distance = distance;
        this.targetVectors = targetVectors;
        this.targets = targets;
    }

    @Generated
    public static NearObjectArgumentBuilder builder() {
        return new NearObjectArgumentBuilder();
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getBeacon() {
        return this.beacon;
    }

    @Generated
    public Float getCertainty() {
        return this.certainty;
    }

    @Generated
    public Float getDistance() {
        return this.distance;
    }

    @Generated
    public String[] getTargetVectors() {
        return this.targetVectors;
    }

    @Generated
    public Targets getTargets() {
        return this.targets;
    }

    @Generated
    public String toString() {
        return "NearObjectArgument(id=" + this.getId() + ", beacon=" + this.getBeacon() + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", targetVectors=" + Arrays.deepToString(this.getTargetVectors()) + ", targets=" + this.getTargets() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NearObjectArgument)) {
            return false;
        }
        NearObjectArgument other = (NearObjectArgument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$certainty = this.getCertainty();
        Float other$certainty = other.getCertainty();
        if (this$certainty == null ? other$certainty != null : !((Object)this$certainty).equals(other$certainty)) {
            return false;
        }
        Float this$distance = this.getDistance();
        Float other$distance = other.getDistance();
        if (this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$beacon = this.getBeacon();
        String other$beacon = other.getBeacon();
        if (this$beacon == null ? other$beacon != null : !this$beacon.equals(other$beacon)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors())) {
            return false;
        }
        Targets this$targets = this.getTargets();
        Targets other$targets = other.getTargets();
        return !(this$targets == null ? other$targets != null : !((Object)this$targets).equals(other$targets));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NearObjectArgument;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $certainty = this.getCertainty();
        result = result * 59 + ($certainty == null ? 43 : ((Object)$certainty).hashCode());
        Float $distance = this.getDistance();
        result = result * 59 + ($distance == null ? 43 : ((Object)$distance).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $beacon = this.getBeacon();
        result = result * 59 + ($beacon == null ? 43 : $beacon.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTargetVectors());
        Targets $targets = this.getTargets();
        result = result * 59 + ($targets == null ? 43 : ((Object)$targets).hashCode());
        return result;
    }

    @Generated
    public static class NearObjectArgumentBuilder {
        @Generated
        private String id;
        @Generated
        private String beacon;
        @Generated
        private Float certainty;
        @Generated
        private Float distance;
        @Generated
        private String[] targetVectors;
        @Generated
        private Targets targets;

        @Generated
        NearObjectArgumentBuilder() {
        }

        @Generated
        public NearObjectArgumentBuilder id(String id) {
            this.id = id;
            return this;
        }

        @Generated
        public NearObjectArgumentBuilder beacon(String beacon) {
            this.beacon = beacon;
            return this;
        }

        @Generated
        public NearObjectArgumentBuilder certainty(Float certainty) {
            this.certainty = certainty;
            return this;
        }

        @Generated
        public NearObjectArgumentBuilder distance(Float distance) {
            this.distance = distance;
            return this;
        }

        @Generated
        public NearObjectArgumentBuilder targetVectors(String[] targetVectors) {
            this.targetVectors = targetVectors;
            return this;
        }

        @Generated
        public NearObjectArgumentBuilder targets(Targets targets) {
            this.targets = targets;
            return this;
        }

        @Generated
        public NearObjectArgument build() {
            return new NearObjectArgument(this.id, this.beacon, this.certainty, this.distance, this.targetVectors, this.targets);
        }

        @Generated
        public String toString() {
            return "NearObjectArgument.NearObjectArgumentBuilder(id=" + this.id + ", beacon=" + this.beacon + ", certainty=" + this.certainty + ", distance=" + this.distance + ", targetVectors=" + Arrays.deepToString(this.targetVectors) + ", targets=" + this.targets + ")";
        }
    }
}

