// Generated by delombok at Tue Dec 10 17:35:26 UTC 2024
package io.weaviate.client.base;

import io.weaviate.client.v1.graphql.model.GraphQLResponse;
import java.util.List;

public class Response<T> {
  private final int statusCode;
  private final T body;
  private final WeaviateErrorResponse errors;

  public Response(int statusCode, T body, WeaviateErrorResponse errors) {
    this.statusCode = statusCode;
    this.body = body;
    if (body instanceof GraphQLResponse) {
      this.errors = getWeaviateGraphQLErrorResponse((GraphQLResponse) body, statusCode);
      ;
    } else {
      this.errors = errors;
    }
  }

  /**
   * Extract errors from {@link WeaviateErrorResponse} from a GraphQL response body.
   *
   * @param gql  GraphQL response body.
   * @param code HTTP status code to pass in the {@link WeaviateErrorResponse}.
   * @return Error response to be returned to the caller.
   */
  private WeaviateErrorResponse getWeaviateGraphQLErrorResponse(GraphQLResponse gql, int code) {
    List<WeaviateErrorMessage> messages = gql.errorMessages();
    if (messages == null || messages.isEmpty()) {
      return null;
    }
    return WeaviateErrorResponse.builder().code(code).error(gql.errorMessages()).build();
  }

  @java.lang.SuppressWarnings("all")
  public int getStatusCode() {
    return this.statusCode;
  }

  @java.lang.SuppressWarnings("all")
  public T getBody() {
    return this.body;
  }

  @java.lang.SuppressWarnings("all")
  public WeaviateErrorResponse getErrors() {
    return this.errors;
  }
}
