// Generated by delombok at Tue Dec 10 17:35:26 UTC 2024
package io.weaviate.client.v1.backup.api;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.v1.backup.model.BackupCreateResponse;
import io.weaviate.client.v1.backup.model.BackupCreateStatusResponse;
import io.weaviate.client.v1.backup.model.CreateStatus;
import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;

public class BackupCreator extends BaseClient<BackupCreateResponse> implements ClientResult<BackupCreateResponse> {
  private static final long WAIT_INTERVAL = 1000;
  private final BackupCreateStatusGetter statusGetter;
  private String[] includeClassNames;
  private String[] excludeClassNames;
  private String backend;
  private String backupId;
  private BackupCreateConfig config;
  private boolean waitForCompletion;

  public BackupCreator(HttpClient httpClient, Config config, BackupCreateStatusGetter statusGetter) {
    super(httpClient, config);
    this.statusGetter = statusGetter;
  }

  public BackupCreator withIncludeClassNames(String... classNames) {
    this.includeClassNames = classNames;
    return this;
  }

  public BackupCreator withExcludeClassNames(String... classNames) {
    this.excludeClassNames = classNames;
    return this;
  }

  public BackupCreator withBackend(String backend) {
    this.backend = backend;
    return this;
  }

  public BackupCreator withBackupId(String backupId) {
    this.backupId = backupId;
    return this;
  }

  public BackupCreator withConfig(BackupCreateConfig config) {
    this.config = config;
    return this;
  }

  public BackupCreator withWaitForCompletion(boolean waitForCompletion) {
    this.waitForCompletion = waitForCompletion;
    return this;
  }

  @Override
  public Result<BackupCreateResponse> run() {
    BackupCreate payload = BackupCreate.builder().id(backupId).config(config).include(includeClassNames).exclude(excludeClassNames).build();
    if (waitForCompletion) {
      return createAndWaitForCompletion(payload);
    }
    return create(payload);
  }

  private Result<BackupCreateResponse> create(BackupCreate payload) {
    Response<BackupCreateResponse> response = sendPostRequest(path(), payload, BackupCreateResponse.class);
    return new Result<>(response);
  }

  private Result<BackupCreateResponse> createAndWaitForCompletion(BackupCreate payload) {
    Result<BackupCreateResponse> result = create(payload);
    if (result.hasErrors()) {
      return result;
    }
    statusGetter.withBackend(backend).withBackupId(backupId);
    while (true) {
      Response<BackupCreateStatusResponse> statusResponse = statusGetter.statusCreate();
      if (new Result<>(statusResponse).hasErrors()) {
        return merge(statusResponse, result);
      }
      switch (statusResponse.getBody().getStatus()) {
      case CreateStatus.SUCCESS: 
      case CreateStatus.FAILED: 
        return merge(statusResponse, result);
      }
      try {
        Thread.sleep(WAIT_INTERVAL);
      } catch (InterruptedException e) {
        return merge(statusResponse, result);
      }
    }
  }

  private String path() {
    return String.format("/backups/%s", backend);
  }

  private Result<BackupCreateResponse> merge(Response<BackupCreateStatusResponse> response, Result<BackupCreateResponse> result) {
    BackupCreateStatusResponse statusCreateResponse = response.getBody();
    BackupCreateResponse createResponse = result.getResult();
    BackupCreateResponse merged = null;
    if (statusCreateResponse != null) {
      merged = new BackupCreateResponse();
      merged.setId(statusCreateResponse.getId());
      merged.setBackend(statusCreateResponse.getBackend());
      merged.setPath(statusCreateResponse.getPath());
      merged.setStatus(statusCreateResponse.getStatus());
      merged.setError(statusCreateResponse.getError());
      merged.setClassNames(createResponse.getClassNames());
    }
    return new Result<>(response.getStatusCode(), merged, response.getErrors());
  }


  private static class BackupCreate {
    String id;
    String[] include;
    String[] exclude;
    BackupCreateConfig config;

    @java.lang.SuppressWarnings("all")
    BackupCreate(final String id, final String[] include, final String[] exclude, final BackupCreateConfig config) {
      this.id = id;
      this.include = include;
      this.exclude = exclude;
      this.config = config;
    }


    @java.lang.SuppressWarnings("all")
    public static class BackupCreateBuilder {
      @java.lang.SuppressWarnings("all")
      private String id;
      @java.lang.SuppressWarnings("all")
      private String[] include;
      @java.lang.SuppressWarnings("all")
      private String[] exclude;
      @java.lang.SuppressWarnings("all")
      private BackupCreateConfig config;

      @java.lang.SuppressWarnings("all")
      BackupCreateBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreate.BackupCreateBuilder id(final String id) {
        this.id = id;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreate.BackupCreateBuilder include(final String[] include) {
        this.include = include;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreate.BackupCreateBuilder exclude(final String[] exclude) {
        this.exclude = exclude;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreate.BackupCreateBuilder config(final BackupCreateConfig config) {
        this.config = config;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreate build() {
        return new BackupCreator.BackupCreate(this.id, this.include, this.exclude, this.config);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      public java.lang.String toString() {
        return "BackupCreator.BackupCreate.BackupCreateBuilder(id=" + this.id + ", include=" + java.util.Arrays.deepToString(this.include) + ", exclude=" + java.util.Arrays.deepToString(this.exclude) + ", config=" + this.config + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    public static BackupCreator.BackupCreate.BackupCreateBuilder builder() {
      return new BackupCreator.BackupCreate.BackupCreateBuilder();
    }

    @java.lang.SuppressWarnings("all")
    public String getId() {
      return this.id;
    }

    @java.lang.SuppressWarnings("all")
    public String[] getInclude() {
      return this.include;
    }

    @java.lang.SuppressWarnings("all")
    public String[] getExclude() {
      return this.exclude;
    }

    @java.lang.SuppressWarnings("all")
    public BackupCreateConfig getConfig() {
      return this.config;
    }
  }


  public static class BackupCreateConfig {
    @SerializedName("CPUPercentage")
    Integer cpuPercentage;
    @SerializedName("ChunkSize")
    Integer chunkSize;
    @SerializedName("CompressionLevel")
    String compressionLevel;
    @SerializedName("Bucket")
    String bucket;
    @SerializedName("Path")
    String path;

    @java.lang.SuppressWarnings("all")
    BackupCreateConfig(final Integer cpuPercentage, final Integer chunkSize, final String compressionLevel, final String bucket, final String path) {
      this.cpuPercentage = cpuPercentage;
      this.chunkSize = chunkSize;
      this.compressionLevel = compressionLevel;
      this.bucket = bucket;
      this.path = path;
    }


    @java.lang.SuppressWarnings("all")
    public static class BackupCreateConfigBuilder {
      @java.lang.SuppressWarnings("all")
      private Integer cpuPercentage;
      @java.lang.SuppressWarnings("all")
      private Integer chunkSize;
      @java.lang.SuppressWarnings("all")
      private String compressionLevel;
      @java.lang.SuppressWarnings("all")
      private String bucket;
      @java.lang.SuppressWarnings("all")
      private String path;

      @java.lang.SuppressWarnings("all")
      BackupCreateConfigBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder cpuPercentage(final Integer cpuPercentage) {
        this.cpuPercentage = cpuPercentage;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder chunkSize(final Integer chunkSize) {
        this.chunkSize = chunkSize;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder compressionLevel(final String compressionLevel) {
        this.compressionLevel = compressionLevel;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder bucket(final String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder path(final String path) {
        this.path = path;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public BackupCreator.BackupCreateConfig build() {
        return new BackupCreator.BackupCreateConfig(this.cpuPercentage, this.chunkSize, this.compressionLevel, this.bucket, this.path);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      public java.lang.String toString() {
        return "BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder(cpuPercentage=" + this.cpuPercentage + ", chunkSize=" + this.chunkSize + ", compressionLevel=" + this.compressionLevel + ", bucket=" + this.bucket + ", path=" + this.path + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    public static BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder builder() {
      return new BackupCreator.BackupCreateConfig.BackupCreateConfigBuilder();
    }

    @java.lang.SuppressWarnings("all")
    public Integer getCpuPercentage() {
      return this.cpuPercentage;
    }

    @java.lang.SuppressWarnings("all")
    public Integer getChunkSize() {
      return this.chunkSize;
    }

    @java.lang.SuppressWarnings("all")
    public String getCompressionLevel() {
      return this.compressionLevel;
    }

    @java.lang.SuppressWarnings("all")
    public String getBucket() {
      return this.bucket;
    }

    @java.lang.SuppressWarnings("all")
    public String getPath() {
      return this.path;
    }
  }


  public interface BackupCompression {
    String DEFAULT_COMPRESSION = "DefaultCompression";
    String BEST_SPEED = "BestSpeed";
    String BEST_COMPRESSION = "BestCompression";
  }
}
