// Generated by delombok at Tue Dec 10 17:35:26 UTC 2024
package io.weaviate.client.v1.batch.util;

import io.weaviate.client.base.util.UrlEncoder;
import org.apache.commons.lang3.StringUtils;
import io.weaviate.client.base.util.TriConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ObjectsPath {
  public String buildCreate(Params params) {
    return build(params, this::addQueryConsistencyLevel);
  }

  public String buildDelete(Params params) {
    return build(params, this::addQueryConsistencyLevel, this::addQueryTenant);
  }

  @SafeVarargs
  private final String build(Params params, TriConsumer<Params, List<String>, List<String>>... appenders) {
    Objects.requireNonNull(params);
    List<String> pathParams = new ArrayList<>();
    List<String> queryParams = new ArrayList<>();
    pathParams.add("/batch/objects");
    Arrays.stream(appenders).forEach(consumer -> consumer.accept(params, pathParams, queryParams));
    String path = String.join("/", pathParams);
    if (!queryParams.isEmpty()) {
      return path + "?" + String.join("&", queryParams);
    }
    return path;
  }

  private void addQueryConsistencyLevel(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.consistencyLevel)) {
      queryParams.add(UrlEncoder.encodeQueryParam("consistency_level", params.consistencyLevel));
    }
  }

  private void addQueryTenant(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.tenant)) {
      queryParams.add(UrlEncoder.encodeQueryParam("tenant", params.tenant));
    }
  }


  public static class Params {
    private final String consistencyLevel;
    private final String tenant;

    @java.lang.SuppressWarnings("all")
    Params(final String consistencyLevel, final String tenant) {
      this.consistencyLevel = consistencyLevel;
      this.tenant = tenant;
    }


    @java.lang.SuppressWarnings("all")
    public static class ParamsBuilder {
      @java.lang.SuppressWarnings("all")
      private String consistencyLevel;
      @java.lang.SuppressWarnings("all")
      private String tenant;

      @java.lang.SuppressWarnings("all")
      ParamsBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public ObjectsPath.Params.ParamsBuilder consistencyLevel(final String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      public ObjectsPath.Params.ParamsBuilder tenant(final String tenant) {
        this.tenant = tenant;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      public ObjectsPath.Params build() {
        return new ObjectsPath.Params(this.consistencyLevel, this.tenant);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      public java.lang.String toString() {
        return "ObjectsPath.Params.ParamsBuilder(consistencyLevel=" + this.consistencyLevel + ", tenant=" + this.tenant + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    public static ObjectsPath.Params.ParamsBuilder builder() {
      return new ObjectsPath.Params.ParamsBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "ObjectsPath.Params(consistencyLevel=" + this.consistencyLevel + ", tenant=" + this.tenant + ")";
    }
  }
}
