// Generated by delombok at Tue Dec 10 17:35:26 UTC 2024
package io.weaviate.client.v1.graphql.query.argument;

import io.weaviate.client.v1.graphql.query.util.Serializer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;

public class NearVectorArgument implements Argument {
  private final Float[] vector;
  private final Float certainty;
  private final Float distance;
  private final String[] targetVectors;
  private final Map<String, Float[][]> vectorsPerTarget;
  private final Targets targets;

  @Override
  public String build() {
    Set<String> arg = new LinkedHashSet<>();
    if (vector != null) {
      arg.add(String.format("vector:%s", Serializer.array(vector)));
    }
    if (certainty != null) {
      arg.add(String.format("certainty:%s", certainty));
    }
    if (distance != null) {
      arg.add(String.format("distance:%s", distance));
    }
    if (ArrayUtils.isNotEmpty(targetVectors)) {
      arg.add(String.format("targetVectors:%s", Serializer.arrayWithQuotes(targetVectors)));
    }
    if (vectorsPerTarget != null && !vectorsPerTarget.isEmpty()) {
      Set<String> vectorPerTargetArg = new LinkedHashSet<>();
      for (Map.Entry<String, Float[][]> e : vectorsPerTarget.entrySet()) {
        Float[][] vectors = e.getValue();
        vectorPerTargetArg.add(String.format("%s:%s", e.getKey(), vectors.length == 1 ? Serializer.array(vectors[0]) : Serializer.array(vectors)));
      }
      arg.add(String.format("vectorPerTarget:{%s}", String.join(" ", vectorPerTargetArg)));
    }
    if (targets != null) {
      arg.add(String.format("%s", withValidTargetVectors(this.targets).build()));
    }
    return String.format("nearVector:{%s}", String.join(" ", arg));
  }

  /**
   * withValidTargetVectors makes sure the target names are repeated for each target vector,
   * which is required by server, but may be easily overlooked by the user.
   *
   * <p>
   * Note, too, that in case the user fails to pass a value in targetVectors altogether, it will not be added to the query.
   *
   * @return A copy of the Targets with validated target vectors.
   */
  private Targets withValidTargetVectors(Targets targets) {
    return Targets.builder().combinationMethod(targets.getCombinationMethod()).weightsMulti(targets.getWeights()).targetVectors(prepareTargetVectors(targets.getTargetVectors())).build();
  }

  /**
   * prepareTargetVectors adds appends the target name for each target vector associated with it.
   */
  private String[] prepareTargetVectors(String[] targets) {
    List<String> out = new ArrayList<>();
    for (String target : targets) {
      if (this.vectorsPerTarget.containsKey(target)) {
        int l = this.vectorsPerTarget.get(target).length;
        for (int i = 0; i < l; i++) {
          out.add(target);
        }
      } else {
        out.add(target);
      }
    }
    return out.toArray(new String[0]);
  }

  // Extend Lombok's builder to overload some methods.
  public static class NearVectorArgumentBuilder {
    @java.lang.SuppressWarnings("all")
    private Float[] vector;
    @java.lang.SuppressWarnings("all")
    private Float certainty;
    @java.lang.SuppressWarnings("all")
    private Float distance;
    @java.lang.SuppressWarnings("all")
    private String[] targetVectors;
    @java.lang.SuppressWarnings("all")
    private Targets targets;
    Map<String, Float[][]> vectorsPerTarget = new LinkedHashMap<>();

    public NearVectorArgumentBuilder vectorPerTarget(Map<String, Float[]> vectors) {
      this.vectorsPerTarget.clear(); // Overwrite the existing entries each time this is called.
      for (Map.Entry<String, Float[]> e : vectors.entrySet()) {
        this.vectorsPerTarget.put(e.getKey(), new Float[][] {e.getValue()});
      }
      return this;
    }

    public NearVectorArgumentBuilder vectorsPerTarget(Map<String, Float[][]> vectors) {
      this.vectorsPerTarget = vectors;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    NearVectorArgumentBuilder() {
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearVectorArgument.NearVectorArgumentBuilder vector(final Float[] vector) {
      this.vector = vector;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearVectorArgument.NearVectorArgumentBuilder certainty(final Float certainty) {
      this.certainty = certainty;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearVectorArgument.NearVectorArgumentBuilder distance(final Float distance) {
      this.distance = distance;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearVectorArgument.NearVectorArgumentBuilder targetVectors(final String[] targetVectors) {
      this.targetVectors = targetVectors;
      return this;
    }

    /**
     * @return {@code this}.
     */
    @java.lang.SuppressWarnings("all")
    public NearVectorArgument.NearVectorArgumentBuilder targets(final Targets targets) {
      this.targets = targets;
      return this;
    }

    @java.lang.SuppressWarnings("all")
    public NearVectorArgument build() {
      return new NearVectorArgument(this.vector, this.certainty, this.distance, this.targetVectors, this.vectorsPerTarget, this.targets);
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    public java.lang.String toString() {
      return "NearVectorArgument.NearVectorArgumentBuilder(vector=" + java.util.Arrays.deepToString(this.vector) + ", certainty=" + this.certainty + ", distance=" + this.distance + ", targetVectors=" + java.util.Arrays.deepToString(this.targetVectors) + ", vectorsPerTarget=" + this.vectorsPerTarget + ", targets=" + this.targets + ")";
    }
  }

  @java.lang.SuppressWarnings("all")
  NearVectorArgument(final Float[] vector, final Float certainty, final Float distance, final String[] targetVectors, final Map<String, Float[][]> vectorsPerTarget, final Targets targets) {
    this.vector = vector;
    this.certainty = certainty;
    this.distance = distance;
    this.targetVectors = targetVectors;
    this.vectorsPerTarget = vectorsPerTarget;
    this.targets = targets;
  }

  @java.lang.SuppressWarnings("all")
  public static NearVectorArgument.NearVectorArgumentBuilder builder() {
    return new NearVectorArgument.NearVectorArgumentBuilder();
  }

  @java.lang.SuppressWarnings("all")
  public Float[] getVector() {
    return this.vector;
  }

  @java.lang.SuppressWarnings("all")
  public Float getCertainty() {
    return this.certainty;
  }

  @java.lang.SuppressWarnings("all")
  public Float getDistance() {
    return this.distance;
  }

  @java.lang.SuppressWarnings("all")
  public String[] getTargetVectors() {
    return this.targetVectors;
  }

  @java.lang.SuppressWarnings("all")
  public Map<String, Float[][]> getVectorsPerTarget() {
    return this.vectorsPerTarget;
  }

  @java.lang.SuppressWarnings("all")
  public Targets getTargets() {
    return this.targets;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "NearVectorArgument(vector=" + java.util.Arrays.deepToString(this.getVector()) + ", certainty=" + this.getCertainty() + ", distance=" + this.getDistance() + ", targetVectors=" + java.util.Arrays.deepToString(this.getTargetVectors()) + ", vectorsPerTarget=" + this.getVectorsPerTarget() + ", targets=" + this.getTargets() + ")";
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof NearVectorArgument)) return false;
    final NearVectorArgument other = (NearVectorArgument) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$certainty = this.getCertainty();
    final java.lang.Object other$certainty = other.getCertainty();
    if (this$certainty == null ? other$certainty != null : !this$certainty.equals(other$certainty)) return false;
    final java.lang.Object this$distance = this.getDistance();
    final java.lang.Object other$distance = other.getDistance();
    if (this$distance == null ? other$distance != null : !this$distance.equals(other$distance)) return false;
    if (!java.util.Arrays.deepEquals(this.getVector(), other.getVector())) return false;
    if (!java.util.Arrays.deepEquals(this.getTargetVectors(), other.getTargetVectors())) return false;
    final java.lang.Object this$vectorsPerTarget = this.getVectorsPerTarget();
    final java.lang.Object other$vectorsPerTarget = other.getVectorsPerTarget();
    if (this$vectorsPerTarget == null ? other$vectorsPerTarget != null : !this$vectorsPerTarget.equals(other$vectorsPerTarget)) return false;
    final java.lang.Object this$targets = this.getTargets();
    final java.lang.Object other$targets = other.getTargets();
    if (this$targets == null ? other$targets != null : !this$targets.equals(other$targets)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof NearVectorArgument;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $certainty = this.getCertainty();
    result = result * PRIME + ($certainty == null ? 43 : $certainty.hashCode());
    final java.lang.Object $distance = this.getDistance();
    result = result * PRIME + ($distance == null ? 43 : $distance.hashCode());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getVector());
    result = result * PRIME + java.util.Arrays.deepHashCode(this.getTargetVectors());
    final java.lang.Object $vectorsPerTarget = this.getVectorsPerTarget();
    result = result * PRIME + ($vectorsPerTarget == null ? 43 : $vectorsPerTarget.hashCode());
    final java.lang.Object $targets = this.getTargets();
    result = result * PRIME + ($targets == null ? 43 : $targets.hashCode());
    return result;
  }
}
