/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.auth;

import io.weaviate.client.Config;
import io.weaviate.client.WeaviateClient;
import io.weaviate.client.v1.auth.Authentication;
import io.weaviate.client.v1.auth.exception.AuthException;
import io.weaviate.client.v1.auth.nimbus.AuthType;
import io.weaviate.client.v1.auth.nimbus.NimbusAuth;
import io.weaviate.client.v1.auth.provider.AccessTokenProvider;
import java.util.ArrayList;
import java.util.List;

public class ResourceOwnerPasswordFlow
implements Authentication {
    private final NimbusAuth nimbusAuth = new NimbusAuth();
    private final String username;
    private final String password;

    public ResourceOwnerPasswordFlow(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public WeaviateClient getAuthClient(Config config, List<String> scopes) throws AuthException {
        AccessTokenProvider tokenProvider = this.nimbusAuth.getAccessTokenProvider(config, "", this.username, this.password, this.addDefaultScopes(scopes), AuthType.USER_PASSWORD);
        return new WeaviateClient(config, tokenProvider);
    }

    @Override
    public WeaviateClient getAuthClient(Config config) throws AuthException {
        return this.getAuthClient(config, null);
    }

    private List<String> addDefaultScopes(List<String> scopes) {
        ArrayList<String> withDefaultScopes = new ArrayList<String>();
        withDefaultScopes.add("offline_access");
        if (scopes != null) {
            scopes.forEach(withDefaultScopes::add);
        }
        return withDefaultScopes;
    }
}

