// Generated by delombok at Thu Apr 10 13:10:53 UTC 2025
package io.weaviate.client;

import java.util.HashMap;
import java.util.Map;

public class Config {
  private static final int DEFAULT_TIMEOUT_SECONDS = 60;
  private final String scheme;
  private final String host;
  private final String version;
  private final Map<String, String> headers = new HashMap<>();
  private final int connectionTimeout;
  private final int connectionRequestTimeout;
  private final int socketTimeout;
  private String proxyHost;
  private int proxyPort;
  private String proxyScheme;
  private boolean gRPCSecured;
  private String gRPCHost;

  public Config(String scheme, String host) {
    this(scheme, host, null, DEFAULT_TIMEOUT_SECONDS, DEFAULT_TIMEOUT_SECONDS, DEFAULT_TIMEOUT_SECONDS);
  }

  public Config(String scheme, String host, boolean gRPCSecured, String gRPCHost) {
    this(scheme, host, null, DEFAULT_TIMEOUT_SECONDS, gRPCSecured, gRPCHost);
  }

  public Config(String scheme, String host, Map<String, String> headers) {
    this(scheme, host, headers, DEFAULT_TIMEOUT_SECONDS, DEFAULT_TIMEOUT_SECONDS, DEFAULT_TIMEOUT_SECONDS);
  }

  public Config(String scheme, String host, boolean gRPCSecured, String gRPCHost, Map<String, String> headers) {
    this(scheme, host, headers, DEFAULT_TIMEOUT_SECONDS, gRPCSecured, gRPCHost);
  }

  public Config(String scheme, String host, Map<String, String> headers, int connectionTimeout, int connectionRequestTimeout, int socketTimeout) {
    this.scheme = scheme;
    this.host = host;
    this.version = "v1";
    this.setHeaders(headers);
    this.connectionTimeout = connectionTimeout;
    this.connectionRequestTimeout = connectionRequestTimeout;
    this.socketTimeout = socketTimeout;
  }

  public Config(String scheme, String host, Map<String, String> headers, int timeout) {
    this(scheme, host, headers, timeout, false, null);
  }

  public Config(String scheme, String host, Map<String, String> headers, int timeout, boolean gRPCSecured, String gRPCHost) {
    this.scheme = scheme;
    this.host = host;
    this.version = "v1";
    this.setHeaders(headers);
    this.connectionTimeout = timeout;
    this.connectionRequestTimeout = timeout;
    this.socketTimeout = timeout;
    this.gRPCSecured = gRPCSecured;
    this.gRPCHost = gRPCHost;
  }

  public String getBaseURL() {
    return scheme + "://" + host + "/" + version;
  }

  public void setProxy(String proxyHost, int proxyPort, String proxyScheme) {
    this.proxyHost = proxyHost;
    this.proxyPort = proxyPort;
    this.proxyScheme = proxyScheme;
  }

  public boolean useGRPC() {
    return this.gRPCHost != null && !this.gRPCHost.trim().isEmpty();
  }

  /**
   * setHeader adds a new header to the headers map. An older entry
   * with the same key will be overwritten.
   */
  void setHeader(String key, String value) {
    this.headers.put(key, value);
  }

  /**
   * setHeaders adds all entries to the headers map. Older entries
   * with the same key will be overwritten.
   *
   * Passing a null map is safe, as it will be ignored.
   */
  void setHeaders(Map<String, String> headers) {
    if (headers != null) {
      this.headers.putAll(headers);
    }
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getScheme() {
    return this.scheme;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getHost() {
    return this.host;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public Map<String, String> getHeaders() {
    return this.headers;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getConnectionTimeout() {
    return this.connectionTimeout;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getConnectionRequestTimeout() {
    return this.connectionRequestTimeout;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getSocketTimeout() {
    return this.socketTimeout;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getProxyHost() {
    return this.proxyHost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getProxyPort() {
    return this.proxyPort;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getProxyScheme() {
    return this.proxyScheme;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean isGRPCSecured() {
    return this.gRPCSecured;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setGRPCSecured(final boolean gRPCSecured) {
    this.gRPCSecured = gRPCSecured;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getGRPCHost() {
    return this.gRPCHost;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setGRPCHost(final String gRPCHost) {
    this.gRPCHost = gRPCHost;
  }
}
