// Generated by delombok at Thu Apr 10 13:10:53 UTC 2025
package io.weaviate.client.v1.backup.api;

import com.google.gson.annotations.SerializedName;
import io.weaviate.client.v1.backup.model.BackupRestoreResponse;
import io.weaviate.client.v1.backup.model.BackupRestoreStatusResponse;
import io.weaviate.client.v1.backup.model.RestoreStatus;
import io.weaviate.client.Config;
import io.weaviate.client.base.BaseClient;
import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.http.HttpClient;

public class BackupRestorer extends BaseClient<BackupRestoreResponse> implements ClientResult<BackupRestoreResponse> {
  private static final long WAIT_INTERVAL = 1000;
  private final BackupRestoreStatusGetter statusGetter;
  private String[] includeClassNames;
  private String[] excludeClassNames;
  private String backend;
  private String backupId;
  private BackupRestoreConfig config;
  private boolean waitForCompletion;

  public BackupRestorer(HttpClient httpClient, Config config, BackupRestoreStatusGetter statusGetter) {
    super(httpClient, config);
    this.statusGetter = statusGetter;
  }

  public BackupRestorer withIncludeClassNames(String... classNames) {
    this.includeClassNames = classNames;
    return this;
  }

  public BackupRestorer withExcludeClassNames(String... classNames) {
    this.excludeClassNames = classNames;
    return this;
  }

  public BackupRestorer withBackend(String backend) {
    this.backend = backend;
    return this;
  }

  public BackupRestorer withConfig(BackupRestoreConfig config) {
    this.config = config;
    return this;
  }

  @Deprecated
  public BackupRestorer backend(String backend) {
    return withBackend(backend);
  }

  public BackupRestorer withBackupId(String backupId) {
    this.backupId = backupId;
    return this;
  }

  public BackupRestorer withWaitForCompletion(boolean waitForCompletion) {
    this.waitForCompletion = waitForCompletion;
    return this;
  }

  @Override
  public Result<BackupRestoreResponse> run() {
    BackupRestore payload = BackupRestore.builder().config(BackupRestoreConfig.builder().build()).include(includeClassNames).exclude(excludeClassNames).config(config).build();
    if (waitForCompletion) {
      return restoreAndWaitForCompletion(payload);
    }
    return restore(payload);
  }

  private Result<BackupRestoreResponse> restore(BackupRestore payload) {
    Response<BackupRestoreResponse> response = sendPostRequest(path(), payload, BackupRestoreResponse.class);
    return new Result<>(response);
  }

  private Result<BackupRestoreResponse> restoreAndWaitForCompletion(BackupRestore payload) {
    Result<BackupRestoreResponse> result = restore(payload);
    if (result.hasErrors()) {
      return result;
    }
    statusGetter.withBackend(backend).withBackupId(backupId);
    while (true) {
      Response<BackupRestoreStatusResponse> statusResponse = statusGetter.statusRestore();
      if (new Result<>(statusResponse).hasErrors()) {
        return merge(statusResponse, result);
      }
      switch (statusResponse.getBody().getStatus()) {
      case RestoreStatus.SUCCESS: 
      case RestoreStatus.FAILED: 
        return merge(statusResponse, result);
      }
      try {
        Thread.sleep(WAIT_INTERVAL);
      } catch (InterruptedException e) {
        return merge(statusResponse, result);
      }
    }
  }

  private String path() {
    return String.format("/backups/%s/%s/restore", backend, backupId);
  }

  private Result<BackupRestoreResponse> merge(Response<BackupRestoreStatusResponse> response, Result<BackupRestoreResponse> result) {
    BackupRestoreStatusResponse statusRestoreResponse = response.getBody();
    BackupRestoreResponse restoreResponse = result.getResult();
    BackupRestoreResponse merged = null;
    if (statusRestoreResponse != null) {
      merged = new BackupRestoreResponse();
      merged.setId(statusRestoreResponse.getId());
      merged.setBackend(statusRestoreResponse.getBackend());
      merged.setPath(statusRestoreResponse.getPath());
      merged.setStatus(statusRestoreResponse.getStatus());
      merged.setError(statusRestoreResponse.getError());
      merged.setClassNames(restoreResponse.getClassNames());
    }
    return new Result<>(response.getStatusCode(), merged, response.getErrors());
  }


  private static class BackupRestore {
    BackupRestoreConfig config;
    String[] include;
    String[] exclude;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    BackupRestore(final BackupRestoreConfig config, final String[] include, final String[] exclude) {
      this.config = config;
      this.include = include;
      this.exclude = exclude;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class BackupRestoreBuilder {
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private BackupRestoreConfig config;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String[] include;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String[] exclude;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      BackupRestoreBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public BackupRestorer.BackupRestore.BackupRestoreBuilder config(final BackupRestoreConfig config) {
        this.config = config;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public BackupRestorer.BackupRestore.BackupRestoreBuilder include(final String[] include) {
        this.include = include;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public BackupRestorer.BackupRestore.BackupRestoreBuilder exclude(final String[] exclude) {
        this.exclude = exclude;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public BackupRestorer.BackupRestore build() {
        return new BackupRestorer.BackupRestore(this.config, this.include, this.exclude);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public java.lang.String toString() {
        return "BackupRestorer.BackupRestore.BackupRestoreBuilder(config=" + this.config + ", include=" + java.util.Arrays.deepToString(this.include) + ", exclude=" + java.util.Arrays.deepToString(this.exclude) + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static BackupRestorer.BackupRestore.BackupRestoreBuilder builder() {
      return new BackupRestorer.BackupRestore.BackupRestoreBuilder();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BackupRestoreConfig getConfig() {
      return this.config;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String[] getInclude() {
      return this.include;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String[] getExclude() {
      return this.exclude;
    }
  }


  public static class BackupRestoreConfig {
    @SerializedName("CPUPercentage")
    Integer cpuPercentage;
    @SerializedName("Bucket")
    String bucket;
    @SerializedName("Path")
    String path;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    BackupRestoreConfig(final Integer cpuPercentage, final String bucket, final String path) {
      this.cpuPercentage = cpuPercentage;
      this.bucket = bucket;
      this.path = path;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class BackupRestoreConfigBuilder {
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private Integer cpuPercentage;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String bucket;
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String path;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      BackupRestoreConfigBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public BackupRestorer.BackupRestoreConfig.BackupRestoreConfigBuilder cpuPercentage(final Integer cpuPercentage) {
        this.cpuPercentage = cpuPercentage;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public BackupRestorer.BackupRestoreConfig.BackupRestoreConfigBuilder bucket(final String bucket) {
        this.bucket = bucket;
        return this;
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public BackupRestorer.BackupRestoreConfig.BackupRestoreConfigBuilder path(final String path) {
        this.path = path;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public BackupRestorer.BackupRestoreConfig build() {
        return new BackupRestorer.BackupRestoreConfig(this.cpuPercentage, this.bucket, this.path);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public java.lang.String toString() {
        return "BackupRestorer.BackupRestoreConfig.BackupRestoreConfigBuilder(cpuPercentage=" + this.cpuPercentage + ", bucket=" + this.bucket + ", path=" + this.path + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static BackupRestorer.BackupRestoreConfig.BackupRestoreConfigBuilder builder() {
      return new BackupRestorer.BackupRestoreConfig.BackupRestoreConfigBuilder();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Integer getCpuPercentage() {
      return this.cpuPercentage;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getBucket() {
      return this.bucket;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getPath() {
      return this.path;
    }
  }
}
