// Generated by delombok at Thu Apr 10 13:10:53 UTC 2025
package io.weaviate.client.v1.batch.util;

import io.weaviate.client.base.util.TriConsumer;
import io.weaviate.client.base.util.UrlEncoder;
import org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ReferencesPath {
  public String buildCreate(Params params) {
    return build(params, this::addQueryConsistencyLevel);
  }

  @SafeVarargs
  private final String build(Params params, TriConsumer<Params, List<String>, List<String>>... appenders) {
    Objects.requireNonNull(params);
    List<String> pathParams = new ArrayList<>();
    List<String> queryParams = new ArrayList<>();
    pathParams.add("/batch/references");
    Arrays.stream(appenders).forEach(consumer -> consumer.accept(params, pathParams, queryParams));
    String path = String.join("/", pathParams);
    if (!queryParams.isEmpty()) {
      return path + "?" + String.join("&", queryParams);
    }
    return path;
  }

  private void addQueryConsistencyLevel(Params params, List<String> pathParams, List<String> queryParams) {
    if (StringUtils.isNotBlank(params.consistencyLevel)) {
      queryParams.add(UrlEncoder.encodeQueryParam("consistency_level", params.consistencyLevel));
    }
  }


  public static class Params {
    private final String consistencyLevel;

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    Params(final String consistencyLevel) {
      this.consistencyLevel = consistencyLevel;
    }


    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static class ParamsBuilder {
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      private String consistencyLevel;

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      ParamsBuilder() {
      }

      /**
       * @return {@code this}.
       */
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ReferencesPath.Params.ParamsBuilder consistencyLevel(final String consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return this;
      }

      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public ReferencesPath.Params build() {
        return new ReferencesPath.Params(this.consistencyLevel);
      }

      @java.lang.Override
      @java.lang.SuppressWarnings("all")
      @lombok.Generated
      public java.lang.String toString() {
        return "ReferencesPath.Params.ParamsBuilder(consistencyLevel=" + this.consistencyLevel + ")";
      }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public static ReferencesPath.Params.ParamsBuilder builder() {
      return new ReferencesPath.Params.ParamsBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
      return "ReferencesPath.Params(consistencyLevel=" + this.consistencyLevel + ")";
    }
  }
}
